/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.QTreeLeafCursor;
import swim.db.QTreeLeafTileCursor;
import swim.db.QTreeNode;
import swim.db.QTreePage;
import swim.db.QTreePageRef;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.spatial.BitInterval;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class QTreeLeaf
extends QTreePage {
    final QTreePageRef pageRef;
    final long version;
    final Slot[] slots;

    protected QTreeLeaf(QTreePageRef pageRef, long version, Slot[] slots) {
        this.pageRef = pageRef;
        this.version = version;
        this.slots = slots;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public QTreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.LEAF;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return this.slots.length == 0;
    }

    @Override
    public int arity() {
        return this.slots.length;
    }

    @Override
    public int childCount() {
        return 0;
    }

    @Override
    public QTreePageRef getChildRef(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public QTreePage getChild(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public int slotCount() {
        return this.slots.length;
    }

    @Override
    public Slot getSlot(int index) {
        return this.slots[index];
    }

    int lookup(Value key) {
        Slot[] slots = this.slots;
        int low = 0;
        int high = slots.length - 1;
        while (low <= high) {
            int i = low + high >>> 1;
            int order = key.compareTo((Item)slots[i].key());
            if (order > 0) {
                low = i + 1;
                continue;
            }
            if (order < 0) {
                high = i - 1;
                continue;
            }
            return i;
        }
        return -(low + 1);
    }

    boolean containsKey(Value key) {
        return this.lookup(key) >= 0;
    }

    @Override
    public boolean containsKey(Value key, long xk, long yk) {
        return this.containsKey(key);
    }

    Value get(Value key) {
        int i = this.lookup(key);
        if (i >= 0) {
            return this.slots[i].toValue().body();
        }
        return Value.absent();
    }

    @Override
    public Value get(Value key, long xk, long yk) {
        return this.get(key);
    }

    @Override
    public QTreeLeaf updated(Value key, long xk, long yk, Value newValue, long newVersion, boolean canSplit) {
        int i = this.lookup(key);
        if (i >= 0) {
            return this.updatedSlot(i, key, xk, yk, newValue, newVersion);
        }
        i = -(i + 1);
        return this.insertedSlot(i, key, xk, yk, newValue, newVersion);
    }

    @Override
    QTreeLeaf updatedSlot(Slot newSlot, long newVersion) {
        int i = this.lookup(newSlot.key());
        if (i >= 0) {
            return this.updatedSlot(i, newSlot, newVersion);
        }
        i = -(i + 1);
        return this.insertedSlot(i, newSlot, newVersion);
    }

    QTreeLeaf updatedSlot(int i, Slot newSlot, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot oldSlot = oldSlots[i];
        if (!newSlot.equals((Object)oldSlot)) {
            int n = oldSlots.length;
            Slot[] newSlots = new Slot[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = newSlot.commit();
            return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
        }
        return this;
    }

    QTreeLeaf insertedSlot(int i, Slot newSlot, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        newSlots[i] = newSlot.commit();
        System.arraycopy(oldSlots, i, newSlots, i + 1, n - (i + 1));
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    QTreeLeaf updatedSlot(int i, Value key, long xk, long yk, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot oldSlot = oldSlots[i];
        Value oldTile = oldSlot.toValue().header("tile");
        long oldX = oldTile.getItem(0).longValue();
        long oldY = oldTile.getItem(1).longValue();
        if (!newValue.equals((Object)oldSlot.toValue()) || oldX != xk || oldY != yk) {
            int n = oldSlots.length;
            Slot[] newSlots = new Slot[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = QTreeLeaf.slot(key, xk, yk, newValue);
            return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
        }
        return this;
    }

    QTreeLeaf insertedSlot(int i, Value key, long xk, long yk, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        newSlots[i] = QTreeLeaf.slot(key, xk, yk, newValue);
        System.arraycopy(oldSlots, i, newSlots, i + 1, n - (i + 1));
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    QTreeLeaf insertedPageRef(QTreePageRef newPageRef, long newVersion) {
        return this.mergedPage(newPageRef.page(), newVersion);
    }

    @Override
    QTreeLeaf mergedPage(QTreePage newPage, long newVersion) {
        if (newPage.isLeaf()) {
            return this.mergedLeaf((QTreeLeaf)newPage, newVersion);
        }
        return this.mergedNode(newPage, newVersion);
    }

    QTreeLeaf mergedLeaf(QTreeLeaf newPage, long newVersion) {
        return this.mergedSlots(newPage.slots, newVersion);
    }

    QTreeLeaf mergedNode(QTreePage newPage, long newVersion) {
        Slot[] oldSlots = this.slots;
        int i = oldSlots.length;
        int n = i + (int)newPage.span();
        Object[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        Cursor<Slot> cursor = newPage.tileCursor();
        while (cursor.hasNext()) {
            newSlots[i] = (Slot)cursor.next();
            ++i;
        }
        BitInterval.sort((Object[])newSlots, QTreePage.SLOT_ORDERING);
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), (Slot[])newSlots);
    }

    @Override
    QTreeLeaf mergedSlots(Slot[] subSlots, long newVersion) {
        Slot[] oldSlots = this.slots;
        Object[] newSlots = new Slot[oldSlots.length + subSlots.length];
        System.arraycopy(oldSlots, 0, newSlots, 0, oldSlots.length);
        System.arraycopy(subSlots, 0, newSlots, oldSlots.length, subSlots.length);
        BitInterval.sort((Object[])newSlots, QTreePage.SLOT_ORDERING);
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), (Slot[])newSlots);
    }

    @Override
    public QTreeLeaf removed(Value key, long xk, long yk, long newVersion) {
        int i = this.lookup(key);
        if (i >= 0) {
            if (this.slots.length > 1) {
                return this.removedSlot(i, newVersion);
            }
            return QTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    QTreeLeaf removedSlot(int i, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        System.arraycopy(oldSlots, i + 1, newSlots, i, n - i);
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public QTreePage flattened(long newVersion) {
        return this;
    }

    @Override
    public QTreePage balanced(long newVersion) {
        if (this.slots.length > 1 && this.pageRef.context.pageShouldSplit(this)) {
            return this.split(newVersion);
        }
        return this;
    }

    @Override
    QTreeNode split(long newVersion) {
        long x = this.pageRef.x;
        long y = this.pageRef.y;
        int xRank = Long.numberOfLeadingZeros(x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(y ^ 0xFFFFFFFFFFFFFFFFL);
        int xnRank = Math.max(0, xRank - 1);
        int ynRank = Math.max(0, yRank - 1);
        long xnMask = (1L << xnRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long ynMask = (1L << ynRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long x0Base = x << xRank;
        long y0Base = y << yRank;
        long x1Base = x0Base | 1L << xnRank;
        long y1Base = y0Base | 1L << ynRank;
        int x00Rank = 0;
        int y00Rank = 0;
        int x01Rank = 0;
        int y01Rank = 0;
        int x10Rank = 0;
        int y10Rank = 0;
        int x11Rank = 0;
        int y11Rank = 0;
        int xX0Rank = 0;
        int yX0Rank = 0;
        int xX1Rank = 0;
        int yX1Rank = 0;
        long x00Base = 0L;
        long y00Base = 0L;
        long x01Base = 0L;
        long y01Base = 0L;
        long x10Base = 0L;
        long y10Base = 0L;
        long x11Base = 0L;
        long y11Base = 0L;
        long xX0Base = 0L;
        long yX0Base = 0L;
        long xX1Base = 0L;
        long yX1Base = 0L;
        long x00Mask = -1L;
        long y00Mask = -1L;
        long x01Mask = -1L;
        long y01Mask = -1L;
        long x10Mask = -1L;
        long y10Mask = -1L;
        long x11Mask = -1L;
        long y11Mask = -1L;
        long xX0Mask = -1L;
        long yX0Mask = -1L;
        long xX1Mask = -1L;
        long yX1Mask = -1L;
        Slot[] slots = this.slots;
        Object[] slots00 = null;
        Object[] slots01 = null;
        Object[] slots10 = null;
        Object[] slots11 = null;
        Object[] slotsX0 = null;
        Object[] slotsX1 = null;
        Object[] slotsXY = null;
        int slotCount = slots.length;
        int slotCount00 = 0;
        int slotCount01 = 0;
        int slotCount10 = 0;
        int slotCount11 = 0;
        int slotCountX0 = 0;
        int slotCountX1 = 0;
        int slotCountXY = 0;
        for (int i = 0; i < slotCount; ++i) {
            Slot slot = slots[i];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            int xtRank = Long.numberOfLeadingZeros(xt ^ 0xFFFFFFFFFFFFFFFFL);
            int ytRank = Long.numberOfLeadingZeros(yt ^ 0xFFFFFFFFFFFFFFFFL);
            long xtBase = xt << xtRank;
            long ytBase = yt << ytRank;
            long xtNorm = xtBase & xnMask;
            long ytNorm = ytBase & ynMask;
            if (xnRank > 0 && xtRank > xnRank) {
                if (ynRank > 0 && ytRank > ynRank) {
                    slotsXY[slotCountXY] = slot;
                    ++slotCountXY;
                    continue;
                }
                if (ytNorm == y0Base) {
                    if (slotsX0 == null) {
                        slotsX0 = new Slot[slotCount];
                    }
                    slotsX0[slotCountX0] = slot;
                    ++slotCountX0;
                    xX0Rank = Math.max(xX0Rank, xtRank);
                    yX0Rank = Math.max(yX0Rank, ytRank);
                    xX0Base |= xtBase;
                    yX0Base |= ytBase;
                    xX0Mask &= xtBase;
                    yX0Mask &= ytBase;
                    continue;
                }
                if (slotsX1 == null) {
                    slotsX1 = new Slot[slotCount];
                }
                slotsX1[slotCountX1] = slot;
                ++slotCountX1;
                xX1Rank = Math.max(xX1Rank, xtRank);
                yX1Rank = Math.max(yX1Rank, ytRank);
                xX1Base |= xtBase;
                yX1Base |= ytBase;
                xX1Mask &= xtBase;
                yX1Mask &= ytBase;
                continue;
            }
            if (xtNorm == x0Base) {
                if (ytNorm == y0Base) {
                    if (slots00 == null) {
                        slots00 = new Slot[slotCount];
                    }
                    slots00[slotCount00] = slot;
                    ++slotCount00;
                    x00Rank = Math.max(x00Rank, xtRank);
                    y00Rank = Math.max(y00Rank, ytRank);
                    x00Base |= xtBase;
                    y00Base |= ytBase;
                    x00Mask &= xtBase;
                    y00Mask &= ytBase;
                    continue;
                }
                if (slots01 == null) {
                    slots01 = new Slot[slotCount];
                }
                slots01[slotCount01] = slot;
                ++slotCount01;
                x01Rank = Math.max(x01Rank, xtRank);
                y01Rank = Math.max(y01Rank, ytRank);
                x01Base |= xtBase;
                y01Base |= ytBase;
                x01Mask &= xtBase;
                y01Mask &= ytBase;
                continue;
            }
            if (ytNorm == y0Base) {
                if (slots10 == null) {
                    slots10 = new Slot[slotCount];
                }
                slots10[slotCount10] = slot;
                ++slotCount10;
                x10Rank = Math.max(x10Rank, xtRank);
                y10Rank = Math.max(y10Rank, ytRank);
                x10Base |= xtBase;
                y10Base |= ytBase;
                x10Mask &= xtBase;
                y10Mask &= ytBase;
                continue;
            }
            if (slots11 == null) {
                slots11 = new Slot[slotCount];
            }
            slots11[slotCount11] = slot;
            ++slotCount11;
            x11Rank = Math.max(x11Rank, xtRank);
            y11Rank = Math.max(y11Rank, ytRank);
            x11Base |= xtBase;
            y11Base |= ytBase;
            x11Mask &= xtBase;
            y11Mask &= ytBase;
        }
        if (slotCountX1 > 0 && (slotCount01 == 0 || slotCount11 == 0)) {
            if (slots01 != null) {
                System.arraycopy(slotsX1, 0, slots01, slotCount01, slotCountX1);
            } else {
                slots01 = slotsX1;
            }
            slotCount01 += slotCountX1;
            x01Rank = Math.max(x01Rank, xX1Rank);
            y01Rank = Math.max(y01Rank, yX1Rank);
            x01Base |= xX1Base;
            y01Base |= yX1Base;
            x01Mask &= xX1Mask;
            y01Mask &= yX1Mask;
            slotsX1 = null;
            slotCountX1 = 0;
            if (slotCount11 > 0) {
                System.arraycopy(slots11, 0, slots01, slotCount01, slotCount11);
                slotCount01 += slotCount11;
                x01Rank = Math.max(x01Rank, x11Rank);
                y01Rank = Math.max(y01Rank, y11Rank);
                x01Base |= x11Base;
                y01Base |= y11Base;
                x01Mask &= x11Mask;
                y01Mask &= y11Mask;
                slots11 = null;
                slotCount11 = 0;
            }
        }
        if (slotCountX0 > 0 && (slotCount00 == 0 || slotCount10 == 0)) {
            if (slots00 != null) {
                System.arraycopy(slotsX0, 0, slots00, slotCount00, slotCountX0);
            } else {
                slots00 = slotsX0;
            }
            slotCount00 += slotCountX0;
            x00Rank = Math.max(x00Rank, xX0Rank);
            y00Rank = Math.max(y00Rank, yX0Rank);
            x00Base |= xX0Base;
            y00Base |= yX0Base;
            x00Mask &= xX0Mask;
            y00Mask &= yX0Mask;
            slotsX0 = null;
            slotCountX0 = 0;
            if (slotCount10 > 0) {
                System.arraycopy(slots10, 0, slots00, slotCount00, slotCount10);
                slotCount00 += slotCount10;
                x00Rank = Math.max(x00Rank, x10Rank);
                y00Rank = Math.max(y00Rank, y10Rank);
                x00Base |= x10Base;
                y00Base |= y10Base;
                x00Mask &= x10Mask;
                y00Mask &= y10Mask;
                slots10 = null;
                slotCount10 = 0;
            }
        }
        if (slotsX0 != null) {
            if (slotsXY == null) {
                slotsXY = new Slot[slotCount];
            }
            System.arraycopy(slotsX0, 0, slotsXY, slotCountXY, slotCountX0);
            slotCountXY += slotCountX0;
            slotsX0 = null;
            slotCountX0 = 0;
        }
        if (slotsX1 != null) {
            if (slotsXY == null) {
                slotsXY = new Slot[slotCount];
            }
            System.arraycopy(slotsX1, 0, slotsXY, slotCountXY, slotCountX1);
            slotCountXY += slotCountX1;
            slotsX1 = null;
            slotCountX1 = 0;
        }
        x00Mask ^= x00Base;
        y00Mask ^= y00Base;
        x01Mask ^= x01Base;
        y01Mask ^= y01Base;
        x10Mask ^= x10Base;
        y10Mask ^= y10Base;
        x11Mask ^= x11Base;
        y11Mask ^= y11Base;
        x00Rank = Math.max(x00Rank, 64 - Long.numberOfLeadingZeros(x00Mask));
        y00Rank = Math.max(y00Rank, 64 - Long.numberOfLeadingZeros(y00Mask));
        x01Rank = Math.max(x01Rank, 64 - Long.numberOfLeadingZeros(x01Mask));
        y01Rank = Math.max(y01Rank, 64 - Long.numberOfLeadingZeros(y01Mask));
        x10Rank = Math.max(x10Rank, 64 - Long.numberOfLeadingZeros(x10Mask));
        y10Rank = Math.max(y10Rank, 64 - Long.numberOfLeadingZeros(y10Mask));
        x11Rank = Math.max(x11Rank, 64 - Long.numberOfLeadingZeros(x11Mask));
        y11Rank = Math.max(y11Rank, 64 - Long.numberOfLeadingZeros(y11Mask));
        long x00 = BitInterval.from((int)x00Rank, (long)x00Base);
        long y00 = BitInterval.from((int)y00Rank, (long)y00Base);
        long x01 = BitInterval.from((int)x01Rank, (long)x01Base);
        long y01 = BitInterval.from((int)y01Rank, (long)y01Base);
        long x10 = BitInterval.from((int)x10Rank, (long)x10Base);
        long y10 = BitInterval.from((int)y10Rank, (long)y10Base);
        long x11 = BitInterval.from((int)x11Rank, (long)x11Base);
        long y11 = BitInterval.from((int)y11Rank, (long)y11Base);
        if (slotCount11 > 0 && slotCount01 > 0 && BitInterval.compare((long)x11, (long)y11, (long)x01, (long)y01) == 0) {
            System.arraycopy(slots11, 0, slots01, slotCount01, slotCount11);
            slotCount01 += slotCount11;
            x01 = BitInterval.union((long)x01, (long)x11);
            y01 = BitInterval.union((long)y01, (long)y11);
            slots11 = null;
            slotCount11 = 0;
        }
        if (slotCount11 > 0 && slotCount10 > 0 && BitInterval.compare((long)x11, (long)y11, (long)x10, (long)y10) == 0) {
            System.arraycopy(slots11, 0, slots10, slotCount10, slotCount11);
            slotCount10 += slotCount11;
            x10 = BitInterval.union((long)x10, (long)x11);
            y10 = BitInterval.union((long)y10, (long)y11);
            slots11 = null;
            slotCount11 = 0;
        }
        if (slotCount11 > 0 && slotCount00 > 0 && BitInterval.compare((long)x11, (long)y11, (long)x00, (long)y00) == 0) {
            System.arraycopy(slots11, 0, slots00, slotCount00, slotCount11);
            slotCount00 += slotCount11;
            x00 = BitInterval.union((long)x00, (long)x11);
            y00 = BitInterval.union((long)y00, (long)y11);
            slots11 = null;
            slotCount11 = 0;
        }
        if (slotCount01 > 0 && slotCount00 > 0 && BitInterval.compare((long)x01, (long)y01, (long)x00, (long)y00) == 0) {
            System.arraycopy(slots01, 0, slots00, slotCount00, slotCount01);
            slotCount00 += slotCount01;
            x00 = BitInterval.union((long)x00, (long)x01);
            y00 = BitInterval.union((long)y00, (long)y01);
            slots01 = null;
            slotCount01 = 0;
        }
        if (slotCount01 > 0 && slotCount10 > 0 && BitInterval.compare((long)x01, (long)y01, (long)x10, (long)y10) == 0) {
            System.arraycopy(slots01, 0, slots10, slotCount10, slotCount01);
            slotCount10 += slotCount01;
            x10 = BitInterval.union((long)x10, (long)x01);
            y10 = BitInterval.union((long)y10, (long)y01);
            slots01 = null;
            slotCount01 = 0;
        }
        if (slotCount10 > 0 && slotCount00 > 0 && BitInterval.compare((long)x10, (long)y10, (long)x00, (long)y00) == 0) {
            System.arraycopy(slots10, 0, slots00, slotCount00, slotCount10);
            slotCount00 += slotCount10;
            x00 = BitInterval.union((long)x00, (long)x10);
            y00 = BitInterval.union((long)y00, (long)y10);
            slots10 = null;
            slotCount10 = 0;
        }
        int pageRefCount = 0;
        if (slotCount00 > 0) {
            ++pageRefCount;
        }
        if (slotCount01 > 0) {
            ++pageRefCount;
        }
        if (slotCount10 > 0) {
            ++pageRefCount;
        }
        if (slotCount11 > 0) {
            ++pageRefCount;
        }
        Object[] pageRefs = new QTreePageRef[pageRefCount];
        int pageRefOffset = 0;
        if (slotCount00 > 0) {
            if (slotCount00 < slotCount) {
                Slot[] newSlots00 = new Slot[slotCount00];
                System.arraycopy(slots00, 0, newSlots00, 0, slotCount00);
                slots00 = newSlots00;
            }
            BitInterval.sort((Object[])slots00, QTreePage.SLOT_ORDERING);
            pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, x00, y00, Value.absent(), (Slot[])slots00).pageRef();
            ++pageRefOffset;
        }
        if (slotCount01 > 0) {
            if (slotCount01 < slotCount) {
                Slot[] newSlots01 = new Slot[slotCount01];
                System.arraycopy(slots01, 0, newSlots01, 0, slotCount01);
                slots01 = newSlots01;
            }
            BitInterval.sort((Object[])slots01, QTreePage.SLOT_ORDERING);
            pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, x01, y01, Value.absent(), (Slot[])slots01).pageRef();
            ++pageRefOffset;
        }
        if (slotCount10 > 0) {
            if (slotCount10 < slotCount) {
                Slot[] newSlots10 = new Slot[slotCount10];
                System.arraycopy(slots10, 0, newSlots10, 0, slotCount10);
                slots10 = newSlots10;
            }
            BitInterval.sort((Object[])slots10, QTreePage.SLOT_ORDERING);
            pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, x10, y10, Value.absent(), (Slot[])slots10).pageRef();
            ++pageRefOffset;
        }
        if (slotCount11 > 0) {
            if (slotCount11 < slotCount) {
                Slot[] newSlots11 = new Slot[slotCount11];
                System.arraycopy(slots11, 0, newSlots11, 0, slotCount11);
                slots11 = newSlots11;
            }
            BitInterval.sort((Object[])slots11, QTreePage.SLOT_ORDERING);
            pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, x11, y11, Value.absent(), (Slot[])slots11).pageRef();
            ++pageRefOffset;
        }
        BitInterval.sort((Object[])pageRefs, QTreePage.PAGE_REF_ORDERING);
        if (slotCountXY == 0) {
            slotsXY = QTreePage.EMPTY_SLOTS;
        } else if (slotCountXY < slotCount) {
            Slot[] newSlotsXY = new Slot[slotCountXY];
            System.arraycopy(slotsXY, 0, newSlotsXY, 0, slotCountXY);
            slotsXY = newSlotsXY;
        }
        BitInterval.sort((Object[])slotsXY, QTreePage.SLOT_ORDERING);
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), (QTreePageRef[])pageRefs, (Slot[])slotsXY);
    }

    @Override
    void memoizeSize(QTreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        Slot[] slots = this.slots;
        int n = slots.length;
        if (n > 0) {
            ++pageSize;
            pageSize += Recon.sizeOf((Item)slots[0]);
            for (int i = 1; i < n; ++i) {
                ++pageSize;
                pageSize += Recon.sizeOf((Item)slots[i]);
            }
            ++pageSize;
        }
        pageRef.pageSize = ++pageSize;
        pageRef.diffSize = pageSize;
        pageRef.treeSize = pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("qleaf", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        Slot[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            record.add((Item)slots[i]);
        }
        return record;
    }

    @Override
    public QTreeLeaf reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        Slot[] slots = this.slots;
        Value fold = identity;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            fold = (Value)accumulator.combine((Object)fold, (Object)slots[i].value());
        }
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.x, this.pageRef.y, fold, slots);
    }

    @Override
    public QTreeLeaf evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.x, this.pageRef.y, this.pageRef.fold, this.slots);
        }
        return this;
    }

    @Override
    public QTreeLeaf committed(int zone, long base, long version) {
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, zone, base, this.pageRef.x, this.pageRef.y, this.pageRef.fold, this.slots);
    }

    @Override
    public QTreeLeaf uncommitted(long version) {
        return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.x, this.pageRef.y, this.pageRef.fold, this.slots);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write(output, (Item)this.toHeader());
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        Slot[] slots = this.slots;
        int n = slots.length;
        if (n > 0) {
            output.write(123);
            Recon.write(output, (Item)slots[0]);
            for (int i = 1; i < n; ++i) {
                output.write(44);
                Recon.write(output, (Item)slots[i]);
            }
            output.write(125);
        }
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.writePage(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        builder.add((Object)this);
    }

    @Override
    public QTreePage loadTree(PageLoader pageLoader) {
        return this;
    }

    @Override
    public void soften(long version) {
    }

    @Override
    public Cursor<Slot> cursor(long x, long y) {
        return new QTreeLeafCursor(this, x, y);
    }

    @Override
    public Cursor<Slot> depthCursor(long x, long y, int maxDepth) {
        return this.cursor(x, y);
    }

    @Override
    public Cursor<Slot> deltaCursor(long x, long y, long sinceVersion) {
        if (sinceVersion <= this.version) {
            return this.cursor(x, y);
        }
        return Cursor.empty();
    }

    @Override
    public Cursor<Slot> tileCursor(long x, long y) {
        return new QTreeLeafTileCursor(this, x, y);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Output)output, (Item)this.toHeader());
        this.writePageContent(output);
        return (String)output.bind();
    }

    public static QTreeLeaf create(PageContext context, int stem, long version, int zone, long base, long x, long y, Value fold, Slot[] slots) {
        QTreePageRef pageRef = new QTreePageRef(context, PageType.LEAF, stem, zone, zone, base, slots.length, x, y, fold);
        QTreeLeaf page = new QTreeLeaf(pageRef, version, slots);
        pageRef.page = page;
        return page;
    }

    public static QTreeLeaf create(PageContext context, int stem, long version, long x, long y, Value fold, Slot[] slots) {
        return QTreeLeaf.create(context, stem, version, 0, 0L, x, y, fold, slots);
    }

    public static QTreeLeaf create(PageContext context, int stem, long version, Value fold, Slot[] slots) {
        int xRank = 0;
        int yRank = 0;
        long xBase = 0L;
        long yBase = 0L;
        long xMask = -1L;
        long yMask = -1L;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            Value tile = slots[i].toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            int xtRank = Long.numberOfLeadingZeros(xt ^ 0xFFFFFFFFFFFFFFFFL);
            int ytRank = Long.numberOfLeadingZeros(yt ^ 0xFFFFFFFFFFFFFFFFL);
            long xtBase = xt << xtRank;
            long ytBase = yt << ytRank;
            xRank = Math.max(xRank, xtRank);
            yRank = Math.max(yRank, ytRank);
            xBase |= xtBase;
            yBase |= ytBase;
            xMask &= xtBase;
            yMask &= ytBase;
        }
        xRank = Math.max(xRank, 64 - Long.numberOfLeadingZeros(xMask ^= xBase));
        yRank = Math.max(yRank, 64 - Long.numberOfLeadingZeros(yMask ^= yBase));
        xMask = (1L << xRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        yMask = (1L << yRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long x = BitInterval.from((int)xRank, (long)(xBase &= xMask));
        long y = BitInterval.from((int)yRank, (long)(yBase &= yMask));
        return QTreeLeaf.create(context, stem, version, 0, 0L, x, y, fold, slots);
    }

    public static QTreeLeaf empty(PageContext context, int stem, long version) {
        return QTreeLeaf.create(context, stem, version, 0, 0L, -1L, -1L, Value.absent(), QTreePage.EMPTY_SLOTS);
    }

    public static QTreeLeaf fromValue(QTreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("qleaf");
            long version = header.get("v").longValue();
            Record tail = value.tail();
            Object[] slots = new Slot[tail.size()];
            tail.toArray(slots);
            return new QTreeLeaf(pageRef, version, (Slot[])slots);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed qleaf: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

