/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.StoreException;
import swim.db.UTreePage;
import swim.db.UTreePageRef;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Cursor;

public final class UTreeLeaf
extends UTreePage {
    final UTreePageRef pageRef;
    final long version;
    final Value value;

    protected UTreeLeaf(UTreePageRef pageRef, long version, Value value) {
        this.pageRef = pageRef;
        this.version = version;
        this.value = value.commit();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public UTreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.LEAF;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public int childCount() {
        return 0;
    }

    @Override
    public UTreePageRef getChildRef(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public UTreePage getChild(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public Value get() {
        return this.value;
    }

    @Override
    public UTreePage updated(Value newValue, long newVersion) {
        if (!newValue.equals((Object)this.value)) {
            return UTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, newValue);
        }
        return this;
    }

    @Override
    public int pageSize() {
        return this.pageRef.pageSize();
    }

    @Override
    public int diffSize() {
        return this.pageRef.diffSize();
    }

    @Override
    public long treeSize() {
        return this.pageRef.treeSize();
    }

    @Override
    void memoizeSize(UTreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        ++pageSize;
        pageSize += Recon.sizeOf((Item)this.value);
        ++pageSize;
        pageRef.pageSize = ++pageSize;
        pageRef.diffSize = pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("uleaf", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        record.add((Item)this.value);
        return record;
    }

    @Override
    public UTreeLeaf evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            return UTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.value);
        }
        return this;
    }

    @Override
    public UTreeLeaf committed(int zone, long base, long version) {
        return UTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, zone, base, this.value);
    }

    @Override
    public UTreeLeaf uncommitted(long version) {
        return UTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.value);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write(output, (Item)this.toHeader());
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        output.write(123);
        Recon.write(output, (Item)this.value);
        output.write(125);
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.writePage(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        builder.add((Object)this);
    }

    @Override
    public UTreePage loadTree(PageLoader pageLoader) {
        return this;
    }

    @Override
    public void soften(long version) {
    }

    @Override
    public Cursor<Value> cursor() {
        return Cursor.unary((Object)this.value);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Output)output, (Item)this.toHeader());
        this.writePageContent(output);
        return (String)output.bind();
    }

    public static UTreeLeaf create(PageContext context, int stem, long version, int zone, long base, Value value) {
        UTreePageRef pageRef = new UTreePageRef(context, stem, zone, zone, base);
        UTreeLeaf page = new UTreeLeaf(pageRef, version, value);
        pageRef.page = page;
        return page;
    }

    public static UTreeLeaf create(PageContext context, int stem, long version, Value value) {
        return UTreeLeaf.create(context, stem, version, 0, 0L, value);
    }

    public static UTreeLeaf empty(PageContext context, int stem, long version) {
        return UTreeLeaf.create(context, stem, version, 0, 0L, Value.absent());
    }

    public static UTreeLeaf fromValue(UTreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("uleaf");
            long version = header.get("v").longValue();
            Value body = value.body();
            return new UTreeLeaf(pageRef, version, body);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed uleaf: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

