/*
 * Decompiled with CFR 0.152.
 */
package swim.dynamic;

import java.util.Collection;
import swim.collections.HashTrieMap;
import swim.dynamic.HostLibrary;
import swim.dynamic.HostPackage;
import swim.dynamic.HostRuntime;
import swim.dynamic.HostType;

public class JavaHostRuntime
implements HostRuntime {
    HashTrieMap<String, HostLibrary> hostLibraries = HashTrieMap.empty();
    HashTrieMap<String, HostPackage> hostPackages = HashTrieMap.empty();
    HashTrieMap<Class<?>, HostType<?>> hostTypes = HashTrieMap.empty();

    @Override
    public final HostLibrary getHostLibrary(String libraryName) {
        return (HostLibrary)this.hostLibraries.get((Object)libraryName);
    }

    @Override
    public final Collection<HostLibrary> hostLibraries() {
        return this.hostLibraries.values();
    }

    @Override
    public final HostPackage getHostPackage(String packageName) {
        return (HostPackage)this.hostPackages.get((Object)packageName);
    }

    @Override
    public final Collection<HostPackage> hostPackages() {
        return this.hostPackages.values();
    }

    @Override
    public final HostType<?> getHostType(Class<?> typeClass) {
        return (HostType)this.hostTypes.get(typeClass);
    }

    @Override
    public final Collection<HostType<?>> hostTypes() {
        return this.hostTypes.values();
    }

    public void addHostLibrary(HostLibrary hostLibrary) {
        String libraryName = hostLibrary.libraryName();
        if (!this.hostLibraries.containsKey((Object)libraryName)) {
            this.hostLibraries = this.hostLibraries.updated((Object)libraryName, (Object)hostLibrary);
            for (HostPackage hostPackage : hostLibrary.hostPackages()) {
                this.addHostPackage(hostPackage);
            }
        }
    }

    public void addHostPackage(HostPackage hostPackage) {
        String packageName = hostPackage.packageName();
        if (!this.hostPackages.containsKey((Object)packageName)) {
            this.hostPackages = this.hostPackages.updated((Object)packageName, (Object)hostPackage);
            for (HostType<?> hostType : hostPackage.hostTypes()) {
                this.addHostType(hostType);
            }
        }
    }

    public void addHostType(HostType<?> hostType) {
        this.hostTypes = this.hostTypes.updated(hostType.hostClass(), hostType);
    }
}

