/*
 * Decompiled with CFR 0.152.
 */
package swim.dynamic;

import java.util.Collection;
import swim.collections.HashTrieMap;
import swim.dynamic.HostPackage;
import swim.dynamic.HostType;

public class JavaHostPackage
implements HostPackage {
    protected final String packageName;
    HashTrieMap<String, HostType<?>> hostTypeNames;
    HashTrieMap<Class<?>, HostType<?>> hostTypeClasses;

    public JavaHostPackage(String packageName) {
        this.packageName = packageName;
        this.hostTypeNames = HashTrieMap.empty();
        this.hostTypeClasses = HashTrieMap.empty();
    }

    @Override
    public final String packageName() {
        return this.packageName;
    }

    @Override
    public final HostType<?> getHostType(String typeName) {
        return (HostType)this.hostTypeNames.get((Object)typeName);
    }

    @Override
    public final HostType<?> getHostType(Class<?> typeClass) {
        return (HostType)this.hostTypeClasses.get(typeClass);
    }

    @Override
    public final Collection<HostType<?>> hostTypes() {
        return this.hostTypeClasses.values();
    }

    public void addHostType(HostType<?> hostType) {
        this.hostTypeNames = this.hostTypeNames.updated((Object)hostType.typeName(), hostType);
        this.hostTypeClasses = this.hostTypeClasses.updated(hostType.hostClass(), hostType);
    }
}

