/*
 * Decompiled with CFR 0.152.
 */
package swim.dynamic;

import java.util.Collection;
import java.util.List;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.dynamic.AbstractHostObjectType;
import swim.dynamic.Bridge;
import swim.dynamic.BridgeException;
import swim.dynamic.HostMember;
import swim.dynamic.HostStaticMember;
import swim.dynamic.HostType;

public class JavaHostObjectType<T>
extends AbstractHostObjectType<T> {
    protected final Class<?> hostClass;
    HostType<? super T> superType;
    FingerTrieSeq<HostType<? super T>> baseTypes;
    HashTrieMap<String, HostMember<? super T>> ownMembers;
    HashTrieMap<String, HostStaticMember> ownStaticMembers;

    public JavaHostObjectType(Class<?> hostClass) {
        this.hostClass = hostClass;
        this.superType = null;
        this.baseTypes = FingerTrieSeq.empty();
        this.ownMembers = HashTrieMap.empty();
        this.ownStaticMembers = HashTrieMap.empty();
    }

    @Override
    public final Class<?> hostClass() {
        return this.hostClass;
    }

    @Override
    public final HostType<? super T> superType() {
        return this.superType;
    }

    @Override
    public final List<HostType<? super T>> baseTypes() {
        return this.baseTypes;
    }

    @Override
    public final HostMember<? super T> getOwnMember(Bridge bridge, T self, String key) {
        return (HostMember)this.ownMembers.get((Object)key);
    }

    @Override
    public final Collection<HostMember<? super T>> ownMembers(Bridge bridge, T self) {
        return this.ownMembers.values();
    }

    @Override
    public final HostStaticMember getOwnStaticMember(Bridge bridge, String key) {
        return (HostStaticMember)this.ownStaticMembers.get((Object)key);
    }

    @Override
    public final Collection<HostStaticMember> ownStaticMembers(Bridge bridge) {
        return this.ownStaticMembers.values();
    }

    public void extendType(HostType<?> superType) {
        if (this.superType != null) {
            throw new BridgeException();
        }
        if (!this.baseTypes.isEmpty()) {
            throw new BridgeException();
        }
        this.superType = superType;
        this.baseTypes = FingerTrieSeq.from(superType.baseTypes()).appended(superType);
    }

    public void inheritType(HostType<?> superType) {
        if (!this.inheritsType(superType)) {
            for (HostType<?> baseType : superType.baseTypes()) {
                if (this.inheritsType(baseType)) continue;
                this.baseTypes = this.baseTypes.appended(baseType);
            }
            this.baseTypes = this.baseTypes.appended(superType);
        }
    }

    public void addMember(HostMember<? super T> member) {
        this.ownMembers = this.ownMembers.updated((Object)member.key(), member);
    }

    public void addStaticMember(HostStaticMember staticMember) {
        this.ownStaticMembers = this.ownStaticMembers.updated((Object)staticMember.key(), (Object)staticMember);
    }
}

