/*
 * Decompiled with CFR 0.152.
 */
package swim.dynamic;

import java.util.Collection;
import java.util.List;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.dynamic.AbstractHostObjectType;
import swim.dynamic.Bridge;
import swim.dynamic.BridgeException;
import swim.dynamic.HostMember;
import swim.dynamic.HostStaticMember;
import swim.dynamic.HostType;
import swim.dynamic.PolyglotObjectTypeSpecialization;

public class PolyglotHostObjectType<T>
extends AbstractHostObjectType<T> {
    protected final Class<?> hostClass;
    HostType<? super T> superType;
    FingerTrieSeq<HostType<? super T>> baseTypes;
    HashTrieMap<String, HostMember<? super T>> ownMembers;
    HashTrieMap<String, HostStaticMember> ownStaticMembers;
    HashTrieMap<String, PolyglotObjectTypeSpecialization<T>> specializations;
    PolyglotObjectTypeSpecialization<T> unspecialized;

    public PolyglotHostObjectType(Class<?> hostClass) {
        this.hostClass = hostClass;
        this.superType = null;
        this.baseTypes = FingerTrieSeq.empty();
        this.ownMembers = HashTrieMap.empty();
        this.ownStaticMembers = HashTrieMap.empty();
        this.specializations = HashTrieMap.empty();
        this.unspecialized = null;
    }

    @Override
    public final Class<?> hostClass() {
        return this.hostClass;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public final HostType<? super T> superType() {
        return this.superType;
    }

    @Override
    public final List<HostType<? super T>> baseTypes() {
        return this.baseTypes;
    }

    @Override
    public HostMember<? super T> getOwnMember(Bridge bridge, T self, String key) {
        HostMember member;
        PolyglotObjectTypeSpecialization specialized = (PolyglotObjectTypeSpecialization)this.specializations.get((Object)bridge.guestLanguage());
        if (specialized != null) {
            member = (HostMember)specialized.ownMembers.get((Object)key);
        } else {
            PolyglotObjectTypeSpecialization<T> unspecialized = this.unspecialized;
            HostMember hostMember = member = unspecialized != null ? (HostMember)unspecialized.ownMembers.get((Object)key) : null;
        }
        if (member == null) {
            member = (HostMember)this.ownMembers.get((Object)key);
        }
        return member;
    }

    @Override
    public Collection<HostMember<? super T>> ownMembers(Bridge bridge, T self) {
        HashTrieMap ownMembers = this.ownMembers;
        PolyglotObjectTypeSpecialization specialized = (PolyglotObjectTypeSpecialization)this.specializations.get((Object)bridge.guestLanguage());
        if (specialized != null) {
            if (!specialized.ownMembers.isEmpty()) {
                ownMembers = ownMembers.updated(specialized.ownMembers);
            }
        } else {
            PolyglotObjectTypeSpecialization<T> unspecialized = this.unspecialized;
            if (unspecialized != null && !unspecialized.ownMembers.isEmpty()) {
                ownMembers = ownMembers.updated(unspecialized.ownMembers);
            }
        }
        return ownMembers.values();
    }

    @Override
    public HostStaticMember getOwnStaticMember(Bridge bridge, String key) {
        HostStaticMember staticMember;
        PolyglotObjectTypeSpecialization specialized = (PolyglotObjectTypeSpecialization)this.specializations.get((Object)bridge.guestLanguage());
        if (specialized != null) {
            staticMember = (HostStaticMember)specialized.ownStaticMembers.get((Object)key);
        } else {
            PolyglotObjectTypeSpecialization<T> unspecialized = this.unspecialized;
            HostStaticMember hostStaticMember = staticMember = unspecialized != null ? (HostStaticMember)unspecialized.ownStaticMembers.get((Object)key) : null;
        }
        if (staticMember == null) {
            staticMember = (HostStaticMember)this.ownStaticMembers.get((Object)key);
        }
        return staticMember;
    }

    @Override
    public Collection<HostStaticMember> ownStaticMembers(Bridge bridge) {
        HashTrieMap ownStaticMembers = this.ownStaticMembers;
        PolyglotObjectTypeSpecialization specialized = (PolyglotObjectTypeSpecialization)this.specializations.get((Object)bridge.guestLanguage());
        if (specialized != null) {
            if (!specialized.ownStaticMembers.isEmpty()) {
                ownStaticMembers = ownStaticMembers.updated(specialized.ownStaticMembers);
            }
        } else {
            PolyglotObjectTypeSpecialization<T> unspecialized = this.unspecialized;
            if (unspecialized != null && !unspecialized.ownMembers.isEmpty()) {
                ownStaticMembers = ownStaticMembers.updated(unspecialized.ownStaticMembers);
            }
        }
        return ownStaticMembers.values();
    }

    public void extendType(HostType<?> superType) {
        if (this.superType != null) {
            throw new BridgeException();
        }
        if (!this.baseTypes.isEmpty()) {
            throw new BridgeException();
        }
        this.superType = superType;
        this.baseTypes = FingerTrieSeq.from(superType.baseTypes()).appended(superType);
    }

    public void inheritType(HostType<?> superType) {
        if (!this.inheritsType(superType)) {
            for (HostType<?> baseType : superType.baseTypes()) {
                if (this.inheritsType(baseType)) continue;
                this.baseTypes = this.baseTypes.appended(baseType);
            }
            this.baseTypes = this.baseTypes.appended(superType);
        }
    }

    public void addMember(HostMember<? super T> member) {
        this.ownMembers = this.ownMembers.updated((Object)member.key(), member);
    }

    public void addStaticMember(HostStaticMember staticMember) {
        this.ownStaticMembers = this.ownStaticMembers.updated((Object)staticMember.key(), (Object)staticMember);
    }

    public void addSpecializedMember(String language, HostMember<? super T> member) {
        PolyglotObjectTypeSpecialization<? super T> specialized = (PolyglotObjectTypeSpecialization<? super T>)this.specializations.get((Object)language);
        if (specialized == null) {
            specialized = new PolyglotObjectTypeSpecialization<T>();
            this.specializations = this.specializations.updated((Object)language, specialized);
        }
        specialized.addMember(member);
    }

    public void addSpecializedStaticMember(String language, HostStaticMember staticMember) {
        PolyglotObjectTypeSpecialization specialized = (PolyglotObjectTypeSpecialization)this.specializations.get((Object)language);
        if (specialized == null) {
            specialized = new PolyglotObjectTypeSpecialization();
            this.specializations = this.specializations.updated((Object)language, specialized);
        }
        specialized.addStaticMember(staticMember);
    }

    public void addUnspecializedMember(HostMember<? super T> member) {
        PolyglotObjectTypeSpecialization<? super T> unspecialized = this.unspecialized;
        if (unspecialized == null) {
            unspecialized = new PolyglotObjectTypeSpecialization();
            this.unspecialized = unspecialized;
        }
        unspecialized.addMember(member);
    }

    public void addUnspecializedStaticMember(HostStaticMember staticMember) {
        PolyglotObjectTypeSpecialization<T> unspecialized = this.unspecialized;
        if (unspecialized == null) {
            unspecialized = new PolyglotObjectTypeSpecialization();
            this.unspecialized = unspecialized;
        }
        unspecialized.addStaticMember(staticMember);
    }
}

