/*
 * Decompiled with CFR 0.152.
 */
package swim.dynamic;

import java.util.Collection;
import java.util.List;
import swim.collections.HashTrieMap;
import swim.dynamic.Bridge;
import swim.dynamic.HostStaticMember;
import swim.dynamic.HostType;

public abstract class AbstractHostType<T>
implements HostType<T> {
    @Override
    public String typeName() {
        return this.hostClass().getSimpleName();
    }

    @Override
    public abstract Class<?> hostClass();

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public abstract HostType<? super T> superType();

    @Override
    public abstract List<HostType<? super T>> baseTypes();

    @Override
    public boolean inheritsType(HostType<?> superType) {
        if (superType == this) {
            return true;
        }
        List<HostType<T>> baseTypes = this.baseTypes();
        for (int i = baseTypes.size() - 1; i >= 0; --i) {
            HostType<T> baseType = baseTypes.get(i);
            if (superType != baseType) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract HostStaticMember getOwnStaticMember(Bridge var1, String var2);

    @Override
    public abstract Collection<HostStaticMember> ownStaticMembers(Bridge var1);

    @Override
    public HostStaticMember getStaticMember(Bridge bridge, String key) {
        HostStaticMember staticMember = this.getOwnStaticMember(bridge, key);
        if (staticMember == null) {
            HostType<T> baseType;
            List<HostType<T>> baseTypes = this.baseTypes();
            for (int i = baseTypes.size() - 1; i >= 0 && (staticMember = (baseType = baseTypes.get(i)).getOwnStaticMember(bridge, key)) == null; --i) {
            }
        }
        return staticMember;
    }

    @Override
    public Collection<HostStaticMember> staticMembers(Bridge bridge) {
        HashTrieMap staticMembers = HashTrieMap.empty();
        List<HostType<T>> baseTypes = this.baseTypes();
        int n = baseTypes.size();
        for (int i = 0; i < n; ++i) {
            HostType<T> baseType = baseTypes.get(i);
            for (HostStaticMember baseStaticMember : baseType.ownStaticMembers(bridge)) {
                staticMembers = staticMembers.updated((Object)baseStaticMember.key(), (Object)baseStaticMember);
            }
        }
        for (HostStaticMember staticMember : this.ownStaticMembers(bridge)) {
            staticMembers = staticMembers.updated((Object)staticMember.key(), (Object)staticMember);
        }
        return staticMembers.values();
    }
}

