/*
 * Decompiled with CFR 0.152.
 */
package swim.dynamic;

import java.util.Collection;
import swim.collections.HashTrieMap;
import swim.dynamic.HostLibrary;
import swim.dynamic.HostPackage;
import swim.dynamic.HostType;

public class JavaHostLibrary
implements HostLibrary {
    protected final String libraryName;
    HashTrieMap<String, HostPackage> hostPackages;
    HashTrieMap<String, HostType<?>> hostTypeNames;
    HashTrieMap<Class<?>, HostType<?>> hostTypeClasses;

    public JavaHostLibrary(String libraryName) {
        this.libraryName = libraryName;
        this.hostPackages = HashTrieMap.empty();
        this.hostTypeNames = HashTrieMap.empty();
        this.hostTypeClasses = HashTrieMap.empty();
    }

    @Override
    public final String libraryName() {
        return this.libraryName;
    }

    @Override
    public final HostPackage getHostPackage(String packageName) {
        return (HostPackage)this.hostPackages.get((Object)packageName);
    }

    @Override
    public final Collection<HostPackage> hostPackages() {
        return this.hostPackages.values();
    }

    @Override
    public final HostType<?> getHostType(String typeName) {
        return (HostType)this.hostTypeNames.get((Object)typeName);
    }

    @Override
    public final HostType<?> getHostType(Class<?> typeClass) {
        return (HostType)this.hostTypeClasses.get(typeClass);
    }

    @Override
    public Collection<HostType<?>> hostTypes() {
        return this.hostTypeClasses.values();
    }

    public void addHostPackage(HostPackage hostPackage) {
        String packageName = hostPackage.packageName();
        if (!this.hostPackages.containsKey((Object)packageName)) {
            this.hostPackages = this.hostPackages.updated((Object)packageName, (Object)hostPackage);
            for (HostType<?> hostType : hostPackage.hostTypes()) {
                this.addHostType(hostType);
            }
        }
    }

    public void addHostType(HostType<?> hostType) {
        this.hostTypeNames = this.hostTypeNames.updated((Object)hostType.typeName(), hostType);
        this.hostTypeClasses = this.hostTypeClasses.updated(hostType.hostClass(), hostType);
    }
}

