// Copyright 2015-2021 Swim inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * HTTP message model and wire protocol codec that incrementally decodes
 * and encodes HTTP streams without intermediate buffering.
 */
module swim.http {
  requires swim.util;
  requires transitive swim.codec;
  requires transitive swim.collections;
  requires transitive swim.uri;
  requires transitive swim.structure;
  requires swim.recon;
  requires swim.json;
  requires swim.xml;
  requires swim.decipher;

  exports swim.http;
  exports swim.http.header;
}
