/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;

final class CommentParser
extends Parser<String> {
    final StringBuilder comment;
    final int level;
    final int step;

    CommentParser(StringBuilder comment, int level, int step) {
        this.comment = comment;
        this.level = level;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<String> parse(Input input, StringBuilder comment, int level, int step) {
        block15: {
            int c = 0;
            if (step == 1) {
                if (input.isCont() && input.head() == 40) {
                    input = input.step();
                    comment = new StringBuilder();
                    level = 1;
                    step = 2;
                } else if (!input.isEmpty()) {
                    return CommentParser.done();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isCommentChar(c = input.head())) {
                        input = input.step();
                        comment.appendCodePoint(c);
                    }
                    if (input.isCont()) {
                        if (c == 40) {
                            input = input.step();
                            comment.append('(');
                            ++level;
                        } else if (c == 41) {
                            input = input.step();
                            if (--level <= 0) return CommentParser.done((Object)comment.toString());
                            comment.append(')');
                        } else {
                            if (c != 92) return CommentParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                            input = input.step();
                            step = 3;
                        }
                    } else if (input.isDone()) {
                        return CommentParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 3) break block15;
                if (!input.isCont()) break;
                c = input.head();
                if (!Http.isEscapeChar(c)) return CommentParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                input = input.step();
                comment.appendCodePoint(c);
                step = 2;
            }
            if (input.isDone()) {
                return CommentParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
            }
        }
        if (!input.isError()) return new CommentParser(comment, level, step);
        return CommentParser.error((Throwable)input.trap());
    }

    static Parser<String> parse(Input input) {
        return CommentParser.parse(input, null, 0, 1);
    }

    public Parser<String> feed(Input input) {
        return CommentParser.parse(input, this.comment, this.level, this.step);
    }
}

