/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.ContentCoding;
import swim.http.Http;
import swim.http.HttpParser;

final class ContentCodingParser
extends Parser<ContentCoding> {
    final HttpParser http;
    final StringBuilder name;
    final Parser<Float> weight;
    final int step;

    ContentCodingParser(HttpParser http, StringBuilder name, Parser<Float> weight, int step) {
        this.http = http;
        this.name = name;
        this.weight = weight;
        this.step = step;
    }

    ContentCodingParser(HttpParser http) {
        this(http, null, null, 1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<ContentCoding> parse(Input input, HttpParser http, StringBuilder name, Parser<Float> weight2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return ContentCodingParser.error((Diagnostic)Diagnostic.expected((String)"content coding", (Input)input));
                input = input.step();
                if (name == null) {
                    name = new StringBuilder();
                }
                name.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return ContentCodingParser.error((Diagnostic)Diagnostic.expected((String)"content coding", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                name.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 3;
            } else if (input.isDone()) {
                return ContentCodingParser.done((Object)http.contentCoding(name.toString(), 1.0f));
            }
        }
        if (step == 3) {
            void weight2222;
            if (weight2222 == null) {
                Parser<Float> weight2222 = http.parseQValue(input);
            } else {
                Object weight2222;
                Parser weight2222 = weight2222.feed(input);
            }
            if (weight2222.isDone()) {
                Float qvalue = (Float)weight2222.bind();
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return ContentCodingParser.done((Object)http.contentCoding(name.toString(), q));
            }
            if (weight2222.isError()) {
                return weight2222.asError();
            }
        }
        if (!input.isError()) void weight2222;
        return new ContentCodingParser(http, name, (Parser<Float>)weight2222, step);
        return ContentCodingParser.error((Throwable)input.trap());
    }

    static Parser<ContentCoding> parse(Input input, HttpParser http) {
        return ContentCodingParser.parse(input, http, null, null, 1);
    }

    public Parser<ContentCoding> feed(Input input) {
        return ContentCodingParser.parse(input, this.http, this.name, this.weight, this.step);
    }
}

