/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.Http;
import swim.http.HttpException;

final class FieldWriter
extends Writer<Object, Object> {
    final String field;
    final int index;

    FieldWriter(String field, int index) {
        this.field = field;
        this.index = index;
    }

    FieldWriter(String field) {
        this(field, 0);
    }

    static Writer<Object, Object> write(Output<?> output, String field, int index) {
        int length = field.length();
        while (index < length && output.isCont()) {
            int c = field.codePointAt(index);
            if (Http.isFieldChar(c)) {
                output = output.write(c);
                index = field.offsetByCodePoints(index, 1);
                continue;
            }
            return FieldWriter.error((Throwable)new HttpException("invalid field: " + field));
        }
        if (index >= length) {
            return FieldWriter.done();
        }
        if (output.isDone()) {
            return FieldWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return FieldWriter.error((Throwable)output.trap());
        }
        return new FieldWriter(field, index);
    }

    static Writer<Object, Object> write(Output<?> output, String field) {
        return FieldWriter.write(output, field, 0);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return FieldWriter.write(output, this.field, this.index);
    }
}

