/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.http.HttpMessage;
import swim.http.HttpValue;
import swim.http.MediaType;
import swim.http.header.ContentType;

final class HttpBodyDecoder<T>
extends Decoder<HttpMessage<T>> {
    final HttpMessage<?> message;
    final Decoder<T> content;
    final long length;
    final long offset;

    HttpBodyDecoder(HttpMessage<?> message, Decoder<T> content, long length, long offset) {
        this.message = message;
        this.content = content;
        this.length = length;
        this.offset = offset;
    }

    HttpBodyDecoder(HttpMessage<?> message, Decoder<T> content, long length) {
        this(message, content, length, 0L);
    }

    static <T> Decoder<HttpMessage<T>> decode(InputBuffer input, HttpMessage<?> message, Decoder<T> content, long length, long offset) {
        int inputStart = input.index();
        int inputLimit = input.limit();
        int inputRemaining = inputLimit - inputStart;
        long outputRemaining = length - offset;
        boolean inputPart = input.isPart();
        if (outputRemaining <= (long)inputRemaining) {
            input = input.limit(inputStart + (int)outputRemaining).isPart(false);
            content = content.feed(input);
            input = input.limit(inputLimit);
        } else {
            input = input.isPart(true);
            content = content.feed(input);
        }
        input = input.isPart(inputPart);
        int inputEnd = input.index();
        inputRemaining = inputLimit - inputEnd;
        outputRemaining = length - (offset += (long)(inputEnd - inputStart));
        if (content.isDone() && inputRemaining > 0 && outputRemaining > 0L) {
            int inputExcess = (int)Math.min((long)inputRemaining, outputRemaining);
            input = input.index(inputEnd + inputExcess);
            offset += (long)inputExcess;
        }
        if (content.isDone()) {
            if (offset < length) {
                return HttpBodyDecoder.error((Throwable)new DecoderException("buffer underflow"));
            }
            if (offset > length) {
                return HttpBodyDecoder.error((Throwable)new DecoderException("buffer overflow"));
            }
            ContentType contentType = message.getHeader(ContentType.class);
            MediaType mediaType = contentType != null ? contentType.mediaType() : null;
            HttpValue<Object> entity = HttpValue.from(content.bind(), mediaType);
            return HttpBodyDecoder.done(message.entity(entity));
        }
        if (content.isError()) {
            return content.asError();
        }
        return new HttpBodyDecoder<T>(message, content, length, offset);
    }

    static <T> Decoder<HttpMessage<T>> decode(InputBuffer input, HttpMessage<?> message, Decoder<T> content, long length) {
        return HttpBodyDecoder.decode(input, message, content, length, 0L);
    }

    public Decoder<HttpMessage<T>> feed(InputBuffer input) {
        return HttpBodyDecoder.decode(input, this.message, this.content, this.length, this.offset);
    }
}

