/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.http.HttpMessage;

final class HttpBodyEncoder<T>
extends Encoder<Object, HttpMessage<T>> {
    final HttpMessage<T> message;
    final Encoder<?, ?> content;
    final long length;
    final long offset;

    HttpBodyEncoder(HttpMessage<T> message, Encoder<?, ?> content, long length, long offset) {
        this.message = message;
        this.content = content;
        this.length = length;
        this.offset = offset;
    }

    HttpBodyEncoder(HttpMessage<T> message, Encoder<?, ?> content, long length) {
        this(message, content, length, 0L);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpMessage<T> message, Encoder<?, ?> content, long length, long offset) {
        int outputStart = output.index();
        int outputLimit = output.limit();
        int outputRemaining = outputLimit - outputStart;
        long inputRemaining = length - offset;
        boolean outputPart = output.isPart();
        if (inputRemaining <= (long)outputRemaining) {
            output = output.limit(outputStart + (int)inputRemaining).isPart(false);
            content = content.pull(output);
            output = output.limit(outputLimit);
        } else {
            output = output.isPart(true);
            content = content.pull(output);
        }
        output = output.isPart(outputPart);
        offset += (long)(output.index() - outputStart);
        if (content.isDone()) {
            if (offset < length) {
                return HttpBodyEncoder.error((Throwable)new EncoderException("buffer underflow"));
            }
            if (offset > length) {
                return HttpBodyEncoder.error((Throwable)new EncoderException("buffer overflow"));
            }
            return HttpBodyEncoder.done(message);
        }
        if (content.isError()) {
            return content.asError();
        }
        if (output.isDone()) {
            return HttpBodyEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return HttpBodyEncoder.error((Throwable)output.trap());
        }
        return new HttpBodyEncoder<T>(message, content, length, offset);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpMessage<T> message, Encoder<?, ?> content, long length) {
        return HttpBodyEncoder.encode(output, message, content, length, 0L);
    }

    public Encoder<Object, HttpMessage<T>> pull(OutputBuffer<?> output) {
        return HttpBodyEncoder.encode(output, this.message, this.content, this.length, this.offset);
    }
}

