/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.http.HttpChunkHeader;
import swim.http.HttpWriter;

final class HttpChunkEncoder
extends Encoder<Object, Object> {
    final HttpWriter http;
    final HttpChunkHeader header;
    final Encoder<?, ?> content;
    final Writer<?, ?> part;
    final int step;

    HttpChunkEncoder(HttpWriter http, HttpChunkHeader header, Encoder<?, ?> content, Writer<?, ?> part, int step) {
        this.http = http;
        this.header = header;
        this.content = content;
        this.part = part;
        this.step = step;
    }

    HttpChunkEncoder(HttpWriter http, HttpChunkHeader header, Encoder<?, ?> content) {
        this(http, header, content, null, 1);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, HttpWriter http, HttpChunkHeader header, Encoder<?, ?> content, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? Utf8.writeEncoded(header.httpWriter(http), output) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return HttpChunkEncoder.error((Throwable)part.trap());
            }
        }
        if (step == 2) {
            if ((content = content.pull(output)).isDone()) {
                step = 3;
            } else if (content.isError()) {
                return content.asError();
            }
        }
        if (step == 3 && output.isCont()) {
            output = output.write(13);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(10);
            return HttpChunkEncoder.done();
        }
        if (output.isDone()) {
            return HttpChunkEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return HttpChunkEncoder.error((Throwable)output.trap());
        }
        return new HttpChunkEncoder(http, header, content, part, step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, HttpWriter http, HttpChunkHeader header, Encoder<?, ?> content) {
        return HttpChunkEncoder.encode(output, http, header, content, null, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return HttpChunkEncoder.encode(output, this.http, this.header, this.content, this.part, this.step);
    }
}

