/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.ChunkExtension;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpChunkHeader
extends HttpPart
implements Debug {
    private static int hashSeed;
    private static HttpChunkHeader sentinel;
    final long size;
    final FingerTrieSeq<ChunkExtension> extensions;

    HttpChunkHeader(long size, FingerTrieSeq<ChunkExtension> extensions) {
        this.size = size;
        this.extensions = extensions;
    }

    public static HttpChunkHeader sentinel() {
        if (sentinel == null) {
            sentinel = new HttpChunkHeader(0L, (FingerTrieSeq<ChunkExtension>)FingerTrieSeq.empty());
        }
        return sentinel;
    }

    public static HttpChunkHeader from(long size, FingerTrieSeq<ChunkExtension> extensions) {
        if (size == 0L && extensions.isEmpty()) {
            return HttpChunkHeader.sentinel();
        }
        return new HttpChunkHeader(size, extensions);
    }

    public static HttpChunkHeader from(long size, ChunkExtension ... extensions) {
        if (size == 0L && extensions.length == 0) {
            return HttpChunkHeader.sentinel();
        }
        return new HttpChunkHeader(size, (FingerTrieSeq<ChunkExtension>)FingerTrieSeq.of((Object[])extensions));
    }

    public static HttpChunkHeader from(long size) {
        if (size == 0L) {
            return HttpChunkHeader.sentinel();
        }
        return new HttpChunkHeader(size, (FingerTrieSeq<ChunkExtension>)FingerTrieSeq.empty());
    }

    public static HttpChunkHeader parse(String string) {
        return Http.standardParser().parseChunkHeaderString(string);
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public long size() {
        return this.size;
    }

    public FingerTrieSeq<ChunkExtension> extensions() {
        return this.extensions;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.chunkHeaderWriter(this.size, this.extensions.iterator());
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeChunkHeader(this.size, this.extensions.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpChunkHeader) {
            HttpChunkHeader that = (HttpChunkHeader)other;
            return this.size == that.size && this.extensions.equals(that.extensions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpChunkHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.size)), (int)this.extensions.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpChunkHeader").write(46);
        if (this.size != 0L || !this.extensions.isEmpty()) {
            output = output.write("from").write(40).debug((Object)this.size);
            for (ChunkExtension extension : this.extensions) {
                output = output.write(", ").debug((Object)extension);
            }
            output = output.write(41);
        } else {
            output = output.write("sentinel").write(40).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

