/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.http.HttpChunkHeader;
import swim.http.HttpChunkTrailer;
import swim.http.HttpMessage;
import swim.http.HttpParser;
import swim.http.HttpValue;
import swim.http.MediaType;
import swim.http.header.ContentType;

final class HttpChunkedDecoder<T>
extends Decoder<HttpMessage<T>> {
    final HttpParser http;
    final HttpMessage<?> message;
    final Decoder<T> content;
    final HttpChunkHeader header;
    final Parser<?> part;
    final int offset;
    final int step;

    HttpChunkedDecoder(HttpParser http, HttpMessage<?> message, Decoder<T> content, HttpChunkHeader header, Parser<?> part, int offset, int step) {
        this.http = http;
        this.message = message;
        this.content = content;
        this.header = header;
        this.part = part;
        this.offset = offset;
        this.step = step;
    }

    HttpChunkedDecoder(HttpParser http, HttpMessage<?> message, Decoder<T> content) {
        this(http, message, content, null, null, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <T> Decoder<HttpMessage<T>> decode(InputBuffer input, HttpParser http, HttpMessage<?> message, Decoder<T> content, HttpChunkHeader header, Parser<?> part, int offset, int step) {
        while (true) {
            block18: {
                if (step == 1) {
                    if ((part = part == null ? Utf8.parseDecoded(http.chunkHeaderParser(), (Input)input) : part.feed(input)).isDone()) {
                        header = (HttpChunkHeader)part.bind();
                        part = null;
                        step = 2;
                    } else if (part.isError()) {
                        return HttpChunkedDecoder.error((Throwable)part.trap());
                    }
                }
                if (step == 2) {
                    int inputStart = input.index();
                    int inputLimit = input.limit();
                    int inputRemaining = inputLimit - inputStart;
                    long chunkSize = header.size();
                    long chunkRemaining = chunkSize - (long)offset;
                    boolean inputPart = input.isPart();
                    if (chunkRemaining < (long)inputRemaining) {
                        input = input.limit(inputStart + (int)chunkRemaining).isPart(chunkSize != 0L);
                        content = content.feed(input);
                        input = input.limit(inputLimit);
                    } else {
                        input = input.isPart(chunkSize != 0L);
                        content = content.feed(input);
                    }
                    input = input.isPart(inputPart);
                    if ((long)(offset += input.index() - inputStart) >= chunkSize) {
                        offset = 0;
                        if (chunkSize > 0L) {
                            step = 3;
                            break block18;
                        } else {
                            step = 5;
                            break;
                        }
                    }
                    if (content.isError()) {
                        return content.asError();
                    }
                }
            }
            if (step == 3 && input.isCont()) {
                if (input.head() != 13) {
                    return HttpChunkedDecoder.error((Throwable)new DecoderException("carriage return"));
                }
                input = input.step();
                step = 4;
            }
            if (step != 4 || !input.isCont()) break;
            if (input.head() != 10) {
                return HttpChunkedDecoder.error((Throwable)new DecoderException("line feed"));
            }
            input = input.step();
            step = 1;
        }
        if (step == 5) {
            if ((part = part == null ? Utf8.parseDecoded(http.chunkTrailerParser(), (Input)input) : part.feed(input)).isDone()) {
                HttpChunkTrailer trailer = (HttpChunkTrailer)part.bind();
                ContentType contentType = (message = message.appendedHeaders(trailer.headers())).getHeader(ContentType.class);
                MediaType mediaType = contentType != null ? contentType.mediaType() : null;
                HttpValue<Object> entity = HttpValue.from(content.bind(), mediaType);
                return HttpChunkedDecoder.done(message.entity(entity));
            }
            if (part.isError()) {
                return HttpChunkedDecoder.error((Throwable)part.trap());
            }
        }
        return new HttpChunkedDecoder<T>(http, message, content, header, part, offset, step);
    }

    static <T> Decoder<HttpMessage<T>> decode(InputBuffer input, HttpParser http, HttpMessage<?> message, Decoder<T> content) {
        return HttpChunkedDecoder.decode(input, http, message, content, null, null, 0, 1);
    }

    public Decoder<HttpMessage<T>> feed(InputBuffer input) {
        return HttpChunkedDecoder.decode(input, this.http, this.message, this.content, this.header, this.part, this.offset, this.step);
    }
}

