/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base16;
import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.http.HttpMessage;

final class HttpChunkedEncoder<T>
extends Encoder<Object, HttpMessage<T>> {
    final HttpMessage<T> message;
    final Encoder<?, ?> content;
    final int step;

    HttpChunkedEncoder(HttpMessage<T> message, Encoder<?, ?> content, int step) {
        this.message = message;
        this.content = content;
        this.step = step;
    }

    HttpChunkedEncoder(HttpMessage<T> message, Encoder<?, ?> content) {
        this(message, content, 1);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpMessage<T> message, Encoder<?, ?> content, int step) {
        if (step == 1 && output.remaining() > 12) {
            int outputStart = output.index();
            int outputEnd = output.limit();
            boolean outputPart = output.isPart();
            output = output.index(outputStart + 10);
            output = output.limit(outputEnd - 2);
            output = output.isPart(true);
            content = content.pull(output);
            int chunkSize = output.index() - outputStart - 10;
            output = output.limit(outputEnd).isPart(outputPart);
            if (chunkSize > 0) {
                output = output.write(13).write(10);
            } else if (content.isCont()) {
                output = output.index(outputStart);
                return new HttpChunkedEncoder<T>(message, content, step);
            }
            int chunkEnd = output.index();
            output = output.index(outputStart + 8).write(13).write(10);
            int chunkStart = outputStart + 7;
            int x = chunkSize;
            while (true) {
                output = output.index(chunkStart).write((int)Base16.uppercase().encodeDigit(x & 0xF));
                if ((x >>>= 4) == 0) break;
                --chunkStart;
            }
            int chunkLength = chunkEnd - chunkStart;
            output = output.move(chunkStart, outputStart, chunkLength).index(outputStart + chunkLength);
            if (content.isDone()) {
                step = chunkSize > 0 ? 2 : 3;
            } else if (content.isError()) {
                return content.asError();
            }
        }
        if (step == 2 && output.remaining() >= 3) {
            output = output.write(48).write(13).write(10);
            step = 3;
        }
        if (step == 3 && output.remaining() >= 2) {
            output = output.write(13).write(10);
            return HttpChunkedEncoder.done(message);
        }
        if (output.isDone()) {
            return HttpChunkedEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return HttpChunkedEncoder.error((Throwable)output.trap());
        }
        return new HttpChunkedEncoder<T>(message, content, step);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpMessage<T> message, Encoder<?, ?> content) {
        return HttpChunkedEncoder.encode(output, message, content, 1);
    }

    public Encoder<Object, HttpMessage<T>> pull(OutputBuffer<?> output) {
        return HttpChunkedEncoder.encode(output, this.message, this.content, this.step);
    }
}

