/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpBody;
import swim.http.HttpEntity;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpMethod;
import swim.http.HttpVersion;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class HttpRequest<T>
extends HttpMessage<T>
implements Debug {
    private static int hashSeed;
    final HttpMethod method;
    final Uri uri;
    final HttpVersion version;
    final FingerTrieSeq<HttpHeader> headers;
    final HttpEntity<T> entity;

    HttpRequest(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers, HttpEntity<T> entity) {
        this.method = method;
        this.uri = uri;
        this.version = version;
        this.headers = headers;
        this.entity = entity;
    }

    HttpRequest(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers) {
        this(method, uri, version, headers, HttpEntity.empty());
    }

    public static <T> HttpRequest<T> from(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers, HttpEntity<T> entity) {
        return new HttpRequest<T>(method, uri, version, headers, entity);
    }

    public static <T> HttpRequest<T> from(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(method, uri, version, headers);
    }

    public static <T> HttpRequest<T> from(HttpMethod method, Uri uri, HttpVersion version, HttpHeader ... headers) {
        return new HttpRequest<T>(method, uri, version, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> from(HttpMethod method, Uri uri, HttpVersion version) {
        return new HttpRequest<T>(method, uri, version, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public static <T> HttpRequest<T> get(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.GET, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> get(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.GET, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> head(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.HEAD, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> head(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.HEAD, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> post(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.POST, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> post(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.POST, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> put(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.PUT, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> put(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.PUT, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> delete(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.DELETE, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> delete(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.DELETE, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> connect(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.CONNECT, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> connect(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.CONNECT, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> options(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.OPTIONS, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> options(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.OPTIONS, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> trace(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.TRACE, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> trace(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.TRACE, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> parseHttp(String string) {
        return Http.standardParser().parseRequestString(string);
    }

    public HttpMethod method() {
        return this.method;
    }

    public HttpRequest<T> method(HttpMethod method) {
        return HttpRequest.from(method, this.uri, this.version, this.headers, this.entity);
    }

    public Uri uri() {
        return this.uri;
    }

    public HttpRequest<T> uri(Uri uri) {
        return HttpRequest.from(this.method, uri, this.version, this.headers, this.entity);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public HttpRequest<T> version(HttpVersion version) {
        return HttpRequest.from(this.method, this.uri, version, this.headers, this.entity);
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        return this.headers;
    }

    @Override
    public HttpRequest<T> headers(FingerTrieSeq<HttpHeader> headers) {
        return HttpRequest.from(this.method, this.uri, this.version, headers, this.entity);
    }

    @Override
    public HttpRequest<T> headers(HttpHeader ... headers) {
        return this.headers(FingerTrieSeq.of((Object[])headers));
    }

    @Override
    public HttpRequest<T> appendedHeaders(FingerTrieSeq<HttpHeader> newHeaders) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq headers = oldHeaders.appended(newHeaders);
        if (oldHeaders != headers) {
            return HttpRequest.from(this.method, this.uri, this.version, (FingerTrieSeq<HttpHeader>)headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpRequest<T> appendedHeaders(HttpHeader ... newHeaders) {
        return this.appendedHeaders(FingerTrieSeq.of((Object[])newHeaders));
    }

    @Override
    public HttpRequest<T> appendedHeader(HttpHeader newHeader) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq headers = oldHeaders.appended((Object)newHeader);
        if (oldHeaders != headers) {
            return HttpRequest.from(this.method, this.uri, this.version, (FingerTrieSeq<HttpHeader>)headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpRequest<T> updatedHeaders(FingerTrieSeq<HttpHeader> newHeaders) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq<HttpHeader> headers = HttpRequest.updatedHeaders(oldHeaders, newHeaders);
        if (oldHeaders != headers) {
            return HttpRequest.from(this.method, this.uri, this.version, headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpRequest<T> updatedHeaders(HttpHeader ... newHeaders) {
        return this.updatedHeaders(FingerTrieSeq.of((Object[])newHeaders));
    }

    @Override
    public HttpRequest<T> updatedHeader(HttpHeader newHeader) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq<HttpHeader> headers = HttpRequest.updatedHeaders(oldHeaders, newHeader);
        if (oldHeaders != headers) {
            return HttpRequest.from(this.method, this.uri, this.version, headers, this.entity);
        }
        return this;
    }

    @Override
    public HttpEntity<T> entity() {
        return this.entity;
    }

    @Override
    public <T2> HttpRequest<T2> entity(HttpEntity<T2> entity) {
        return HttpRequest.from(this.method, this.uri, this.version, this.headers, entity);
    }

    @Override
    public <T2> HttpRequest<T2> content(HttpEntity<T2> entity) {
        FingerTrieSeq<HttpHeader> headers = HttpRequest.updatedHeaders(this.headers, entity.headers());
        return HttpRequest.from(this.method, this.uri, this.version, headers, entity);
    }

    public HttpRequest<String> body(String content, MediaType mediaType) {
        return this.content(HttpBody.from(content, mediaType));
    }

    public HttpRequest<String> body(String content) {
        return this.content(HttpBody.from(content));
    }

    @Override
    public <T2> Decoder<HttpRequest<T2>> entityDecoder(Decoder<T2> contentDecoder) {
        return super.entityDecoder(contentDecoder);
    }

    @Override
    public Encoder<?, HttpRequest<T>> httpEncoder(HttpWriter http) {
        return super.httpEncoder(http);
    }

    @Override
    public Encoder<?, HttpRequest<T>> httpEncoder() {
        return super.httpEncoder();
    }

    @Override
    public Encoder<?, HttpRequest<T>> encodeHttp(OutputBuffer<?> output, HttpWriter http) {
        return super.encodeHttp(output, http);
    }

    @Override
    public Encoder<?, HttpRequest<T>> encodeHttp(OutputBuffer<?> output) {
        return super.encodeHttp(output);
    }

    public Writer<?, HttpRequest<T>> httpWriter(HttpWriter http) {
        return http.requestWriter(this);
    }

    public Writer<?, HttpRequest<T>> httpWriter() {
        return this.httpWriter(Http.standardWriter());
    }

    public Writer<?, HttpRequest<T>> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeRequest(this, output);
    }

    public Writer<?, HttpRequest<T>> writeHttp(Output<?> output) {
        return this.writeHttp(output, Http.standardWriter());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpRequest) {
            HttpRequest that = (HttpRequest)other;
            return this.method.equals(that.method) && this.uri.equals((Object)that.uri) && this.version.equals(that.version) && this.headers.equals(that.headers) && this.entity.equals(that.entity);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpRequest.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.method.hashCode()), (int)this.uri.hashCode()), (int)this.version.hashCode()), (int)this.headers.hashCode()), (int)this.entity.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpRequest").write(46).write("from").write(40).debug((Object)this.method).write(", ").debug((Object)this.uri).write(", ").debug((Object)this.version);
        for (HttpHeader header : this.headers) {
            output = output.write(", ").debug((Object)header);
        }
        output = output.write(41);
        if (this.entity.isDefined()) {
            output = output.write(46).write("entity").write(40).debug(this.entity).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

