/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.http.HttpVersion;
import swim.util.Builder;

final class HttpResponseParser<T>
extends Parser<HttpResponse<T>> {
    final HttpParser http;
    final Parser<HttpVersion> version;
    final Parser<HttpStatus> status;
    final Parser<? extends HttpHeader> header;
    final Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers;
    final int step;

    HttpResponseParser(HttpParser http, Parser<HttpVersion> version, Parser<HttpStatus> status, Parser<? extends HttpHeader> header, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        this.http = http;
        this.version = version;
        this.status = status;
        this.header = header;
        this.headers = headers;
        this.step = step;
    }

    HttpResponseParser(HttpParser http) {
        this(http, null, null, null, null, 1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <T> Parser<HttpResponse<T>> parse(Input input, HttpParser http, Parser<HttpVersion> version, Parser<HttpStatus> status22222, Parser<? extends HttpHeader> header32222, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        void status22222;
        void header32222;
        block49: {
            int c = 0;
            if (step == 1) {
                if (version == null) {
                    if (input.isDone()) {
                        return HttpResponseParser.done();
                    }
                    version = http.parseVersion(input);
                } else {
                    version = version.feed(input);
                }
                if (version.isDone()) {
                    step = 2;
                } else if (version.isError()) {
                    return version.asError();
                }
            }
            if (step == 2) {
                if (input.isCont() && input.head() == 32) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
                }
            }
            if (step == 3) {
                void status22222;
                if (status22222 == null) {
                    Parser<HttpStatus> status22222 = http.parseStatus(input);
                } else {
                    Object status22222;
                    Parser status22222 = status22222.feed(input);
                }
                if (status22222.isDone()) {
                    step = 4;
                } else if (status22222.isError()) {
                    return status22222.asError();
                }
            }
            if (step == 4) {
                if (input.isCont() && input.head() == 13) {
                    input = input.step();
                    step = 5;
                } else if (!input.isEmpty()) {
                    return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                }
            }
            if (step == 5) {
                if (input.isCont() && input.head() == 10) {
                    input = input.step();
                    step = 6;
                } else if (!input.isEmpty()) {
                    return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                }
            }
            while (true) {
                if (step == 6) {
                    if (input.isCont()) {
                        c = input.head();
                        if (Http.isTokenChar(c)) {
                            step = 7;
                        } else {
                            if (Http.isSpace(c)) {
                                return HttpResponseParser.error((Diagnostic)Diagnostic.message((String)"unsupported header line extension", (Input)input));
                            }
                            if (c != 13) return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                            input = input.step();
                            step = 10;
                        }
                    } else if (input.isDone()) {
                        return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                    }
                }
                if (step == 7) {
                    void header32222;
                    if (header32222 == null) {
                        Parser<HttpHeader> header32222 = http.parseHeader(input);
                    } else {
                        void header32222;
                        Parser header32222 = header32222.feed(input);
                    }
                    if (header32222.isDone()) {
                        step = 8;
                    } else if (header32222.isError()) {
                        return header32222.asError();
                    }
                }
                if (step == 8) {
                    if (input.isCont() && input.head() == 13) {
                        input = input.step();
                        step = 9;
                    } else if (!input.isEmpty()) {
                        return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                    }
                }
                if (step != 9) break block49;
                if (!input.isCont() || input.head() != 10) break;
                if (headers == null) {
                    headers = FingerTrieSeq.builder();
                }
                headers.add((Object)((HttpHeader)header32222.bind()));
                Object header32222 = null;
                input = input.step();
                step = 6;
            }
            if (!input.isEmpty()) {
                return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (step == 10) {
            if (input.isCont() && input.head() == 10) {
                input = input.step();
                if (headers == null) {
                    HttpResponse response = http.response((HttpVersion)version.bind(), (HttpStatus)status22222.bind(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
                    return HttpResponseParser.done(response);
                }
                HttpResponse response = http.response((HttpVersion)version.bind(), (HttpStatus)status22222.bind(), (FingerTrieSeq<HttpHeader>)((FingerTrieSeq)headers.bind()));
                return HttpResponseParser.done(response);
            }
            if (!input.isEmpty()) {
                return HttpResponseParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (!input.isError()) return new HttpResponseParser<T>(http, version, (Parser<HttpStatus>)status22222, (Parser<? extends HttpHeader>)header32222, (Builder<HttpHeader, FingerTrieSeq<HttpHeader>>)headers, step);
        return HttpResponseParser.error((Throwable)input.trap());
    }

    static <T> Parser<HttpResponse<T>> parse(Input input, HttpParser http) {
        return HttpResponseParser.parse(input, http, null, null, null, null, 1);
    }

    public Parser<HttpResponse<T>> feed(Input input) {
        return HttpResponseParser.parse(input, this.http, this.version, this.status, this.header, this.headers, this.step);
    }
}

