/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpHeader;
import swim.http.HttpResponse;
import swim.http.HttpWriter;

final class HttpResponseWriter<T>
extends Writer<Object, HttpResponse<T>> {
    final HttpWriter http;
    final HttpResponse<T> response;
    final Iterator<HttpHeader> headers;
    final Writer<?, ?> part;
    final int step;

    HttpResponseWriter(HttpWriter http, HttpResponse<T> response, Iterator<HttpHeader> headers, Writer<?, ?> part, int step) {
        this.http = http;
        this.response = response;
        this.headers = headers;
        this.part = part;
        this.step = step;
    }

    HttpResponseWriter(HttpWriter http, HttpResponse<T> response) {
        this(http, response, null, null, 1);
    }

    static <T> Writer<Object, HttpResponse<T>> write(Output<?> output, HttpWriter http, HttpResponse<T> response, Iterator<HttpHeader> headers, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? response.version.writeHttp(output, http) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(32);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? response.status.writeHttp(output, http) : part.pull(output)).isDone()) {
                part = null;
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(13);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(10);
            step = 6;
        }
        while (true) {
            if (step == 6) {
                if (part == null) {
                    if (headers == null) {
                        headers = response.headers.iterator();
                    }
                    if (!headers.hasNext()) {
                        step = 9;
                        break;
                    }
                    part = ((HttpHeader)headers.next()).writeHttp(output, http);
                } else {
                    part = part.pull(output);
                }
                if (part.isDone()) {
                    part = null;
                    step = 7;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 7 && output.isCont()) {
                output = output.write(13);
                step = 8;
            }
            if (step != 8 || !output.isCont()) break;
            output = output.write(10);
            step = 6;
        }
        if (step == 9 && output.isCont()) {
            output = output.write(13);
            step = 10;
        }
        if (step == 10 && output.isCont()) {
            output = output.write(10);
            return HttpResponseWriter.done(response);
        }
        if (output.isDone()) {
            return HttpResponseWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return HttpResponseWriter.error((Throwable)output.trap());
        }
        return new HttpResponseWriter<T>(http, response, headers, part, step);
    }

    static <T> Writer<Object, HttpResponse<T>> write(Output<?> output, HttpWriter http, HttpResponse<T> response) {
        return HttpResponseWriter.write(output, http, response, null, null, 1);
    }

    public Writer<Object, HttpResponse<T>> pull(Output<?> output) {
        return HttpResponseWriter.write(output, this.http, this.response, this.headers, this.part, this.step);
    }
}

