/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.HttpStatus;

final class HttpStatusParser
extends Parser<HttpStatus> {
    final HttpParser http;
    final int code;
    final Output<String> phrase;
    final int step;

    HttpStatusParser(HttpParser http, int code, Output<String> phrase, int step) {
        this.http = http;
        this.code = code;
        this.phrase = phrase;
        this.step = step;
    }

    HttpStatusParser(HttpParser http) {
        this(http, 0, null, 1);
    }

    static Parser<HttpStatus> parse(Input input, HttpParser http, int code, Output<String> phrase, int step) {
        int c = 0;
        while (step <= 3) {
            if (input.isCont()) {
                c = input.head();
                if (Base10.isDigit((int)c)) {
                    input = input.step();
                    code = 10 * code + Base10.decodeDigit((int)c);
                    ++step;
                    continue;
                }
                return HttpStatusParser.error((Diagnostic)Diagnostic.expected((String)"status code", (Input)input));
            }
            if (!input.isDone()) break;
            return HttpStatusParser.error((Diagnostic)Diagnostic.expected((String)"status code", (Input)input));
        }
        if (step == 4) {
            if (input.isCont() && input.head() == 32) {
                input = input.step();
                step = 5;
            } else if (!input.isEmpty()) {
                return HttpStatusParser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
            }
        }
        if (step == 5) {
            if (phrase == null) {
                phrase = Utf8.decodedString();
            }
            while (input.isCont() && Http.isPhraseChar(c = input.head())) {
                input = input.step();
                phrase.write(c);
            }
            if (!input.isEmpty()) {
                return HttpStatusParser.done((Object)http.status(code, (String)phrase.bind()));
            }
        }
        if (input.isError()) {
            return HttpStatusParser.error((Throwable)input.trap());
        }
        return new HttpStatusParser(http, code, (Output<String>)phrase, step);
    }

    static Parser<HttpStatus> parse(Input input, HttpParser http) {
        return HttpStatusParser.parse(input, http, 0, null, 1);
    }

    public Parser<HttpStatus> feed(Input input) {
        return HttpStatusParser.parse(input, this.http, this.code, this.phrase, this.step);
    }
}

