/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpEntity;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.util.Murmur3;

public final class HttpValue<T>
extends HttpEntity<T>
implements Debug {
    private static int hashSeed;
    final T value;
    final MediaType mediaType;

    HttpValue(T value, MediaType mediaType) {
        this.value = value;
        this.mediaType = mediaType;
    }

    public static <T> HttpValue<T> from(T value, MediaType mediaType) {
        return new HttpValue<T>(value, mediaType);
    }

    public static <T> HttpValue<T> from(T value) {
        return new HttpValue<T>(value, null);
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public FingerTrieSeq<TransferCoding> transferCodings() {
        return FingerTrieSeq.empty();
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        return FingerTrieSeq.empty();
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message, HttpWriter http) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(HttpMessage<T2> message, OutputBuffer<?> output, HttpWriter http) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpValue) {
            HttpValue that = (HttpValue)other;
            return (this.value == null ? that.value == null : this.value.equals(that.value)) && (this.mediaType == null ? that.mediaType == null : this.mediaType.equals(that.mediaType));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpValue.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)), (int)Murmur3.hash((Object)this.mediaType)));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpValue").write(46).write("from").write(40).debug(this.value);
        if (this.mediaType != null) {
            output = output.write(", ").debug((Object)this.mediaType);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

