/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpVersion
extends HttpPart
implements Debug {
    public static final HttpVersion HTTP_1_1 = new HttpVersion(1, 1);
    public static final HttpVersion HTTP_1_0 = new HttpVersion(1, 0);
    private static int hashSeed;
    final int major;
    final int minor;

    HttpVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static HttpVersion from(int major, int minor) {
        if (major == 1 && minor == 1) {
            return HTTP_1_1;
        }
        if (major == 1 && minor == 0) {
            return HTTP_1_0;
        }
        if (major >= 0 && minor >= 0) {
            return new HttpVersion(major, minor);
        }
        throw new IllegalArgumentException(major + ", " + minor);
    }

    public static HttpVersion parseHttp(String string) {
        return Http.standardParser().parseVersionString(string);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.versionWriter(this.major, this.minor);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeVersion(this.major, this.minor, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpVersion) {
            HttpVersion that = (HttpVersion)other;
            return this.major == that.major && this.minor == that.minor;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpVersion.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.major), (int)this.minor));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpVersion").write(46);
        output = this.major == 1 && (this.minor == 1 || this.minor == 0) ? output.write("HTTP").write(95).debug((Object)this.major).write(95).debug((Object)this.minor) : output.write("from").write(40).debug((Object)this.major).write(", ").debug((Object)this.minor).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

