/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class HttpVersionWriter
extends Writer<Object, Object> {
    final int major;
    final int minor;
    final int step;

    HttpVersionWriter(int major, int minor, int step) {
        this.major = major;
        this.minor = minor;
        this.step = step;
    }

    HttpVersionWriter(int major, int minor) {
        this(major, minor, 1);
    }

    static Writer<Object, Object> write(Output<?> output, int major, int minor, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(72);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(84);
            step = 3;
        }
        if (step == 3 && output.isCont()) {
            output = output.write(84);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(80);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(47);
            step = 6;
        }
        if (step == 6 && output.isCont()) {
            output = output.write(Base10.encodeDigit((int)(major % 10)));
            step = 7;
        }
        if (step == 7 && output.isCont()) {
            output = output.write(46);
            step = 8;
        }
        if (step == 8 && output.isCont()) {
            output = output.write(Base10.encodeDigit((int)(minor % 10)));
            return HttpVersionWriter.done();
        }
        if (output.isDone()) {
            return HttpVersionWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return HttpVersionWriter.error((Throwable)output.trap());
        }
        return new HttpVersionWriter(major, minor, step);
    }

    static Writer<Object, Object> write(Output<?> output, int major, int minor) {
        return HttpVersionWriter.write(output, major, minor, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HttpVersionWriter.write(output, this.major, this.minor, this.step);
    }
}

