/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class LanguageRange
extends HttpPart
implements Debug {
    private static int hashSeed;
    private static LanguageRange star;
    final String tag;
    final String subtag;
    final float weight;

    LanguageRange(String tag, String subtag, float weight) {
        this.tag = tag;
        this.subtag = subtag;
        this.weight = weight;
    }

    LanguageRange(String tag, String subtag) {
        this(tag, subtag, 1.0f);
    }

    LanguageRange(String tag, float weight) {
        this(tag, null, weight);
    }

    LanguageRange(String tag) {
        this(tag, null, 1.0f);
    }

    public static LanguageRange star() {
        if (star == null) {
            star = new LanguageRange("*");
        }
        return star;
    }

    public static LanguageRange from(String tag, String subtag, float weight) {
        if (weight == 1.0f) {
            return LanguageRange.from(tag, subtag);
        }
        return new LanguageRange(tag, subtag, weight);
    }

    public static LanguageRange from(String tag, String subtag) {
        if (subtag == null) {
            return LanguageRange.from(tag);
        }
        return new LanguageRange(tag, subtag);
    }

    public static LanguageRange from(String tag, float weight) {
        if (weight == 1.0f) {
            return LanguageRange.from(tag);
        }
        return new LanguageRange(tag, weight);
    }

    public static LanguageRange from(String tag) {
        if ("*".equals(tag)) {
            return LanguageRange.star();
        }
        return new LanguageRange(tag);
    }

    public static LanguageRange parse(String string) {
        return Http.standardParser().parseLanguageRangeString(string);
    }

    public String tag() {
        return this.tag;
    }

    public String subtag() {
        return this.subtag;
    }

    public float weight() {
        return this.weight;
    }

    public LanguageRange weight(float weight) {
        return new LanguageRange(this.tag, this.subtag, weight);
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.languageRangeWriter(this.tag, this.subtag, this.weight);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeLanguageRange(this.tag, this.subtag, this.weight, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LanguageRange) {
            LanguageRange that = (LanguageRange)other;
            return this.tag.equals(that.tag) && (this.subtag == null ? that.subtag == null : this.subtag.equals(that.subtag)) && this.weight == that.weight;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(LanguageRange.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.tag.hashCode()), (int)Murmur3.hash((Object)this.subtag)), (int)Murmur3.hash((float)this.weight)));
    }

    public void debug(Output<?> output) {
        output = output.write("LanguageRange").write(46).write("from").write(40).debug((Object)this.tag);
        if (this.subtag != null) {
            output = output.write(", ").debug((Object)this.subtag);
        }
        if (this.weight != 1.0f) {
            output = output.write(", ").debug((Object)Float.valueOf(this.weight));
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

