/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Map;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class MediaRange
extends HttpPart
implements Debug {
    private static int hashSeed;
    final String type;
    final String subtype;
    final float weight;
    final HashTrieMap<String, String> params;

    MediaRange(String type, String subtype, float weight, HashTrieMap<String, String> params) {
        this.type = type;
        this.subtype = subtype;
        this.weight = weight;
        this.params = params;
    }

    MediaRange(String type, String subtype, float weight) {
        this(type, subtype, weight, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    MediaRange(String type, String subtype, HashTrieMap<String, String> params) {
        this(type, subtype, 1.0f, params);
    }

    MediaRange(String type, String subtype) {
        this(type, subtype, 1.0f, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public static MediaRange from(String type, String subtype, float weight, HashTrieMap<String, String> params) {
        return new MediaRange(type, subtype, weight, params);
    }

    public static MediaRange from(String type, String subtype, float weight) {
        return new MediaRange(type, subtype, weight);
    }

    public static MediaRange from(String type, String subtype, HashTrieMap<String, String> params) {
        return new MediaRange(type, subtype, params);
    }

    public static MediaRange from(String type, String subtype) {
        return new MediaRange(type, subtype);
    }

    public static MediaRange parse(String string) {
        return Http.standardParser().parseMediaRangeString(string);
    }

    public boolean isApplication() {
        return "application".equalsIgnoreCase(this.type);
    }

    public boolean isAudio() {
        return "audio".equalsIgnoreCase(this.type);
    }

    public boolean isImage() {
        return "image".equalsIgnoreCase(this.type);
    }

    public boolean isMultipart() {
        return "multipart".equalsIgnoreCase(this.type);
    }

    public boolean isText() {
        return "text".equalsIgnoreCase(this.type);
    }

    public boolean isVideo() {
        return "video".equalsIgnoreCase(this.type);
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public float weight() {
        return this.weight;
    }

    public MediaRange weight(float weight) {
        return new MediaRange(this.type, this.subtype, weight, this.params);
    }

    public HashTrieMap<String, String> params() {
        return this.params;
    }

    public String getParam(String key) {
        return (String)this.params.get((Object)key);
    }

    public MediaRange param(String key, String value) {
        return new MediaRange(this.type, this.subtype, this.weight, (HashTrieMap<String, String>)this.params.updated((Object)key, (Object)value));
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.mediaRangeWriter(this.type, this.subtype, this.weight, this.params);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeMediaRange(this.type, this.subtype, this.weight, this.params, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MediaRange) {
            MediaRange that = (MediaRange)other;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.weight == that.weight && this.params.equals(that.params);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MediaRange.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.type.hashCode()), (int)this.subtype.hashCode()), (int)Murmur3.hash((float)this.weight)), (int)this.params.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("MediaRange").write(46).write("from").write(40).debug((Object)this.type).write(", ").debug((Object)this.subtype);
        if (this.weight != 1.0f) {
            output = output.write(", ").debug((Object)Float.valueOf(this.weight));
        }
        output = output.write(41);
        for (Map.Entry param : this.params) {
            output = output.write(46).write("param").write(40).debug(param.getKey()).write(", ").debug(param.getValue()).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

