/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.MediaRange;

final class MediaRangeParser
extends Parser<MediaRange> {
    final HttpParser http;
    final StringBuilder type;
    final StringBuilder subtype;
    final Parser<Float> weight;
    final Parser<HashTrieMap<String, String>> params;
    final int step;

    MediaRangeParser(HttpParser http, StringBuilder type, StringBuilder subtype, Parser<Float> weight, Parser<HashTrieMap<String, String>> params, int step) {
        this.http = http;
        this.type = type;
        this.subtype = subtype;
        this.weight = weight;
        this.params = params;
        this.step = step;
    }

    MediaRangeParser(HttpParser http) {
        this(http, null, null, null, null, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<MediaRange> parse(Input input, HttpParser http, StringBuilder type, StringBuilder subtype, Parser<Float> weight, Parser<HashTrieMap<String, String>> params, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return MediaRangeParser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
                input = input.step();
                if (type == null) {
                    type = new StringBuilder();
                }
                type.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return MediaRangeParser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                type.appendCodePoint(c);
            }
            if (input.isCont() && c == 47) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return MediaRangeParser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return MediaRangeParser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
                input = input.step();
                if (subtype == null) {
                    subtype = new StringBuilder();
                }
                subtype.appendCodePoint(c);
                step = 4;
            } else if (input.isDone()) {
                return MediaRangeParser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
            }
        }
        if (step == 4) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                subtype.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 5;
            }
        }
        if (step == 5) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont() && c == 59) {
                input = input.step();
                step = 6;
            } else if (!input.isEmpty()) {
                return MediaRangeParser.done((Object)http.mediaRange(type.toString(), subtype.toString(), 1.0f, (HashTrieMap<String, String>)HashTrieMap.empty()));
            }
        }
        if (step == 6) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 113) {
                    input = input.step();
                    step = 7;
                } else {
                    params = http.parseParamMapRest(input);
                    step = 9;
                }
            } else if (input.isDone()) {
                return MediaRangeParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 7) {
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    weight = http.parseQValueRest(input);
                    step = 8;
                } else {
                    params = http.parseParamMapRest(new StringBuilder().append('q'), input);
                    step = 9;
                }
            } else if (input.isDone()) {
                return MediaRangeParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 8) {
            if ((weight = weight.feed(input)).isDone()) {
                step = 9;
            } else if (weight.isError()) {
                return weight.asError();
            }
        }
        if (step == 9) {
            if ((params = params == null ? http.parseParamMap(input) : params.feed(input)).isDone()) {
                Float qvalue = weight != null ? (Float)weight.bind() : null;
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return MediaRangeParser.done((Object)http.mediaRange(type.toString(), subtype.toString(), q, (HashTrieMap<String, String>)((HashTrieMap)params.bind())));
            }
            if (params.isError()) {
                return params.asError();
            }
        }
        if (!input.isError()) return new MediaRangeParser(http, type, subtype, weight, params, step);
        return MediaRangeParser.error((Throwable)input.trap());
    }

    static Parser<MediaRange> parse(Input input, HttpParser http) {
        return MediaRangeParser.parse(input, http, null, null, null, null, 1);
    }

    public Parser<MediaRange> feed(Input input) {
        return MediaRangeParser.parse(input, this.http, this.type, this.subtype, this.weight, this.params, this.step);
    }
}

