/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.MediaType;

final class MediaTypeParser
extends Parser<MediaType> {
    final HttpParser http;
    final StringBuilder type;
    final StringBuilder subtype;
    final Parser<HashTrieMap<String, String>> params;
    final int step;

    MediaTypeParser(HttpParser http, StringBuilder type, StringBuilder subtype, Parser<HashTrieMap<String, String>> params, int step) {
        this.http = http;
        this.type = type;
        this.subtype = subtype;
        this.params = params;
        this.step = step;
    }

    MediaTypeParser(HttpParser http) {
        this(http, null, null, null, 1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<MediaType> parse(Input input, HttpParser http, StringBuilder type, StringBuilder subtype, Parser<HashTrieMap<String, String>> params2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return MediaTypeParser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
                input = input.step();
                if (type == null) {
                    type = new StringBuilder();
                }
                type.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return MediaTypeParser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                type.appendCodePoint(c);
            }
            if (input.isCont() && c == 47) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return MediaTypeParser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return MediaTypeParser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
                input = input.step();
                if (subtype == null) {
                    subtype = new StringBuilder();
                }
                subtype.appendCodePoint(c);
                step = 4;
            } else if (input.isDone()) {
                return MediaTypeParser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
            }
        }
        if (step == 4) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                subtype.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 5;
            }
        }
        if (step == 5) {
            void params2222;
            if (params2222 == null) {
                Parser<HashTrieMap<String, String>> params2222 = http.parseParamMap(input);
            } else {
                Object params2222;
                Parser params2222 = params2222.feed(input);
            }
            if (params2222.isDone()) {
                return MediaTypeParser.done((Object)http.mediaType(type.toString(), subtype.toString(), (HashTrieMap<String, String>)((HashTrieMap)params2222.bind())));
            }
            if (params2222.isError()) {
                return params2222.asError();
            }
        }
        if (!input.isError()) void params2222;
        return new MediaTypeParser(http, type, subtype, (Parser<HashTrieMap<String, String>>)params2222, step);
        return MediaTypeParser.error((Throwable)input.trap());
    }

    static Parser<MediaType> parse(Input input, HttpParser http) {
        return MediaTypeParser.parse(input, http, null, null, null, 1);
    }

    public Parser<MediaType> feed(Input input) {
        return MediaTypeParser.parse(input, this.http, this.type, this.subtype, this.params, this.step);
    }
}

