/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpPart;
import swim.http.HttpWriter;

final class ParamListWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final Iterator<? extends HttpPart> params;
    final Writer<?, ?> param;
    final int step;

    ParamListWriter(HttpWriter http, Iterator<? extends HttpPart> params, Writer<?, ?> param, int step) {
        this.http = http;
        this.params = params;
        this.param = param;
        this.step = step;
    }

    ParamListWriter(HttpWriter http, Iterator<? extends HttpPart> params) {
        this(http, params, null, 1);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<? extends HttpPart> params, Writer<?, ?> param, int step) {
        while (true) {
            if (step == 1) {
                if (param == null) {
                    if (!params.hasNext()) {
                        return ParamListWriter.done();
                    }
                    param = params.next().writeHttp(output, http);
                } else {
                    param = param.pull(output);
                }
                if (param.isDone()) {
                    param = null;
                    if (!params.hasNext()) {
                        return ParamListWriter.done();
                    }
                    step = 2;
                } else if (param.isError()) {
                    return param.asError();
                }
            }
            if (step == 2 && output.isCont()) {
                output = output.write(44);
                step = 3;
            }
            if (step != 3 || !output.isCont()) break;
            output = output.write(32);
            step = 1;
        }
        if (output.isDone()) {
            return ParamListWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return ParamListWriter.error((Throwable)output.trap());
        }
        return new ParamListWriter(http, params, param, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<? extends HttpPart> params) {
        return ParamListWriter.write(output, http, params, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ParamListWriter.write(output, this.http, this.params, this.param, this.step);
    }
}

