/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;

final class ParamMapParser
extends Parser<HashTrieMap<String, String>> {
    final StringBuilder key;
    final StringBuilder value;
    final HashTrieMap<String, String> params;
    final int step;

    ParamMapParser(StringBuilder key, StringBuilder value, HashTrieMap<String, String> params, int step) {
        this.key = key;
        this.value = value;
        this.params = params;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HashTrieMap<String, String>> parse(Input input, StringBuilder key, StringBuilder value, HashTrieMap<String, String> params, int step) {
        block45: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 59) {
                        input = input.step();
                        step = 2;
                    } else if (!input.isEmpty()) {
                        if (params != null) return ParamMapParser.done((Object)params);
                        params = HashTrieMap.empty();
                        return ParamMapParser.done((Object)params);
                    }
                }
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (!Http.isTokenChar(c)) return ParamMapParser.error((Diagnostic)Diagnostic.expected((String)"param name", (Input)input));
                        key = new StringBuilder();
                        input = input.step();
                        key.appendCodePoint(c);
                        step = 3;
                    } else if (input.isDone()) {
                        return ParamMapParser.error((Diagnostic)Diagnostic.expected((String)"param name", (Input)input));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isTokenChar(c = input.head())) {
                        input = input.step();
                        key.appendCodePoint(c);
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return ParamMapParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step == 4) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 61) {
                        input = input.step();
                        step = 5;
                    } else if (!input.isEmpty()) {
                        return ParamMapParser.error((Diagnostic)Diagnostic.expected((int)61, (Input)input));
                    }
                }
                if (step == 5) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (value == null) {
                            value = new StringBuilder();
                        }
                        if (c == 34) {
                            input = input.step();
                            step = 8;
                        } else {
                            step = 6;
                        }
                    } else if (input.isDone()) {
                        return ParamMapParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step == 6) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Http.isTokenChar(c)) return ParamMapParser.error((Diagnostic)Diagnostic.expected((String)"param value", (Input)input));
                        input = input.step();
                        value.appendCodePoint(c);
                        step = 7;
                    } else if (input.isDone()) {
                        return ParamMapParser.error((Diagnostic)Diagnostic.expected((String)"param value", (Input)input));
                    }
                }
                if (step == 7) {
                    while (input.isCont() && Http.isTokenChar(c = input.head())) {
                        input = input.step();
                        value.appendCodePoint(c);
                    }
                    if (!input.isEmpty()) {
                        if (params == null) {
                            params = HashTrieMap.empty();
                        }
                        params = params.updated((Object)key.toString(), (Object)value.toString());
                        key = null;
                        value = null;
                        step = 1;
                        continue;
                    }
                }
                if (step == 8) {
                    while (input.isCont() && Http.isQuotedChar(c = input.head())) {
                        input = input.step();
                        value.appendCodePoint(c);
                    }
                    if (input.isCont()) {
                        if (c == 34) {
                            input = input.step();
                            if (params == null) {
                                params = HashTrieMap.empty();
                            }
                            params = params.updated((Object)key.toString(), (Object)value.toString());
                            key = null;
                            value = null;
                            step = 1;
                            continue;
                        }
                        if (c != 92) return ParamMapParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                        input = input.step();
                        step = 9;
                    } else if (input.isDone()) {
                        return ParamMapParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 9) break block45;
                if (!input.isCont()) break;
                c = input.head();
                if (!Http.isEscapeChar(c)) return ParamMapParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                input = input.step();
                value.appendCodePoint(c);
                step = 8;
            }
            if (input.isDone()) {
                return ParamMapParser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
            }
        }
        if (!input.isError()) return new ParamMapParser(key, value, (HashTrieMap<String, String>)params, step);
        return ParamMapParser.error((Throwable)input.trap());
    }

    static Parser<HashTrieMap<String, String>> parse(Input input) {
        return ParamMapParser.parse(input, null, null, null, 1);
    }

    static Parser<HashTrieMap<String, String>> parseRest(Input input) {
        return ParamMapParser.parse(input, null, null, null, 2);
    }

    static Parser<HashTrieMap<String, String>> parseRest(Input input, StringBuilder key) {
        return ParamMapParser.parse(input, key, null, null, 3);
    }

    public Parser<HashTrieMap<String, String>> feed(Input input) {
        return ParamMapParser.parse(input, this.key, this.value, this.params, this.step);
    }
}

