/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class ParamWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String key;
    final String value;
    final Writer<?, ?> part;
    final int step;

    ParamWriter(HttpWriter http, String key, String value, Writer<?, ?> part, int step) {
        this.http = http;
        this.key = key;
        this.value = value;
        this.part = part;
        this.step = step;
    }

    ParamWriter(HttpWriter http, String key, String value) {
        this(http, key, value, null, 1);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String key, String value, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(key, output) : part.pull(output)).isDone()) {
                part = null;
                if (value.isEmpty()) {
                    return ParamWriter.done();
                }
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(61);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? http.writeValue(value, output) : part.pull(output)).isDone()) {
                return ParamWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return ParamWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return ParamWriter.error((Throwable)output.trap());
        }
        return new ParamWriter(http, key, value, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String key, String value) {
        return ParamWriter.write(output, http, key, value, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ParamWriter.write(output, this.http, this.key, this.value, this.part, this.step);
    }
}

