/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.Http;
import swim.http.HttpException;

final class PhraseWriter
extends Writer<Object, Object> {
    final String phrase;
    final int index;

    PhraseWriter(String phrase, int index) {
        this.phrase = phrase;
        this.index = index;
    }

    PhraseWriter(String phrase) {
        this(phrase, 0);
    }

    static Writer<Object, Object> write(Output<?> output, String phrase, int index) {
        int length = phrase.length();
        while (index < length && output.isCont()) {
            int c = phrase.codePointAt(index);
            if (Http.isPhraseChar(c)) {
                output = output.write(c);
                index = phrase.offsetByCodePoints(index, 1);
                continue;
            }
            return PhraseWriter.error((Throwable)new HttpException("invalid phrase: " + phrase));
        }
        if (index >= length) {
            return PhraseWriter.done();
        }
        if (output.isDone()) {
            return PhraseWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return PhraseWriter.error((Throwable)output.trap());
        }
        return new PhraseWriter(phrase, index);
    }

    static Writer<Object, Object> write(Output<?> output, String phrase) {
        return PhraseWriter.write(output, phrase, 0);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return PhraseWriter.write(output, this.phrase, this.index);
    }
}

