/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.Http;
import swim.http.HttpException;

final class QuotedWriter
extends Writer<Object, Object> {
    final String quoted;
    final int index;
    final int escape;
    final int step;

    QuotedWriter(String quoted, int index, int escape, int step) {
        this.quoted = quoted;
        this.index = index;
        this.escape = escape;
        this.step = step;
    }

    QuotedWriter(String quoted) {
        this(quoted, 0, 0, 1);
    }

    static Writer<Object, Object> write(Output<?> output, String quoted, int index, int escape, int step) {
        int length = quoted.length();
        if (step == 1 && output.isCont()) {
            output = output.write(34);
            step = 2;
        }
        while (true) {
            if (step == 2 && output.isCont()) {
                if (index < length) {
                    int c = quoted.codePointAt(index);
                    if (Http.isQuotedChar(c)) {
                        output = output.write(c);
                    } else if (Http.isVisibleChar(c)) {
                        output = output.write(92);
                        escape = c;
                        step = 3;
                    } else {
                        return QuotedWriter.error((Throwable)new HttpException("invalid quoted: " + quoted));
                    }
                    index = quoted.offsetByCodePoints(index, 1);
                    continue;
                }
                step = 4;
                break;
            }
            if (step != 3 || !output.isCont()) break;
            output = output.write(escape);
            escape = 0;
            step = 2;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(34);
            return QuotedWriter.done();
        }
        if (output.isDone()) {
            return QuotedWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return QuotedWriter.error((Throwable)output.trap());
        }
        return new QuotedWriter(quoted, index, escape, step);
    }

    static Writer<Object, Object> write(Output<?> output, String quoted) {
        return QuotedWriter.write(output, quoted, 0, 0, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return QuotedWriter.write(output, this.quoted, this.index, this.escape, this.step);
    }
}

