/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.collections.HashTrieMap;
import swim.http.HttpWriter;

final class TransferCodingWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String name;
    final HashTrieMap<String, String> params;
    final Writer<?, ?> part;
    final int step;

    TransferCodingWriter(HttpWriter http, String name, HashTrieMap<String, String> params, Writer<?, ?> part, int step) {
        this.http = http;
        this.name = name;
        this.params = params;
        this.part = part;
        this.step = step;
    }

    TransferCodingWriter(HttpWriter http, String name, HashTrieMap<String, String> params) {
        this(http, name, params, null, 1);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, HashTrieMap<String, String> params, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(name, output) : part.pull(output)).isDone()) {
                part = null;
                if (params.isEmpty()) {
                    return TransferCodingWriter.done();
                }
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2) {
            if ((part = part == null ? http.writeParamMap(params.iterator(), output) : part.pull(output)).isDone()) {
                return TransferCodingWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return TransferCodingWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return TransferCodingWriter.error((Throwable)output.trap());
        }
        return new TransferCodingWriter(http, name, params, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, HashTrieMap<String, String> params) {
        return TransferCodingWriter.write(output, http, name, params, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return TransferCodingWriter.write(output, this.http, this.name, this.params, this.part, this.step);
    }
}

