/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class UpgradeProtocol
extends HttpPart
implements Debug {
    private static int hashSeed;
    private static UpgradeProtocol websocket;
    final String name;
    final String version;

    UpgradeProtocol(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public static UpgradeProtocol websocket() {
        if (websocket == null) {
            websocket = new UpgradeProtocol("websocket", "");
        }
        return websocket;
    }

    public static UpgradeProtocol from(String name, String version) {
        if ("".equals(version)) {
            return UpgradeProtocol.from(name);
        }
        return new UpgradeProtocol(name, version);
    }

    public static UpgradeProtocol from(String name) {
        if ("websocket".equals(name)) {
            return UpgradeProtocol.websocket();
        }
        return new UpgradeProtocol(name, "");
    }

    public static UpgradeProtocol parse(String string) {
        return Http.standardParser().parseUpgradeProtocolString(string);
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.upgradeProtocolWriter(this.name, this.version);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeUpgradeProtocol(this.name, this.version, output);
    }

    public boolean matches(UpgradeProtocol that) {
        if (this == that) {
            return true;
        }
        return this.name.equalsIgnoreCase(that.name) && this.version.equals(that.version);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UpgradeProtocol) {
            UpgradeProtocol that = (UpgradeProtocol)other;
            return this.name.equals(that.name) && this.version.equals(that.version);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UpgradeProtocol.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.version.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("UpgradeProtocol").write(46).write("from").write(40).debug((Object)this.name);
        if (!this.version.isEmpty()) {
            output = output.write(", ").debug((Object)this.version);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

