/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class UpgradeProtocolWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String name;
    final String version;
    final Writer<?, ?> part;
    final int step;

    UpgradeProtocolWriter(HttpWriter http, String name, String version, Writer<?, ?> part, int step) {
        this.http = http;
        this.name = name;
        this.version = version;
        this.part = part;
        this.step = step;
    }

    UpgradeProtocolWriter(HttpWriter http, String name, String version) {
        this(http, name, version, null, 1);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, String version, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(name, output) : part.pull(output)).isDone()) {
                part = null;
                if (version.isEmpty()) {
                    return UpgradeProtocolWriter.done();
                }
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(47);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? http.writeToken(version, output) : part.pull(output)).isDone()) {
                return UpgradeProtocolWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return UpgradeProtocolWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return UpgradeProtocolWriter.error((Throwable)output.trap());
        }
        return new UpgradeProtocolWriter(http, name, version, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, String version) {
        return UpgradeProtocolWriter.write(output, http, name, version, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return UpgradeProtocolWriter.write(output, this.http, this.name, this.version, this.part, this.step);
    }
}

