/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.WebSocketExtension;
import swim.http.WebSocketParam;
import swim.util.Builder;

final class WebSocketExtensionParser
extends Parser<WebSocketExtension> {
    final HttpParser http;
    final StringBuilder name;
    final Parser<WebSocketParam> param;
    final Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>> params;
    final int step;

    WebSocketExtensionParser(HttpParser http, StringBuilder name, Parser<WebSocketParam> param, Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>> params, int step) {
        this.http = http;
        this.name = name;
        this.param = param;
        this.params = params;
        this.step = step;
    }

    WebSocketExtensionParser(HttpParser http) {
        this(http, null, null, null, 1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<WebSocketExtension> parse(Input input, HttpParser http, StringBuilder name, Parser<WebSocketParam> param3222, Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>> params, int step) {
        block21: {
            void param3222;
            int c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return WebSocketExtensionParser.error((Diagnostic)Diagnostic.expected((String)"websocket extension", (Input)input));
                    input = input.step();
                    if (name == null) {
                        name = new StringBuilder();
                    }
                    name.appendCodePoint(c);
                    step = 2;
                } else if (input.isDone()) {
                    return WebSocketExtensionParser.error((Diagnostic)Diagnostic.expected((String)"websocket extension", (Input)input));
                }
            }
            if (step == 2) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    name.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 3;
                }
            }
            while (true) {
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 59) {
                        if (params == null) {
                            params = FingerTrieSeq.builder();
                        }
                        input = input.step();
                        step = 4;
                    } else if (!input.isEmpty()) {
                        return WebSocketExtensionParser.done((Object)http.webSocketExtension(name.toString(), (FingerTrieSeq<WebSocketParam>)(params != null ? (FingerTrieSeq)params.bind() : FingerTrieSeq.empty())));
                    }
                }
                if (step == 4) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (!input.isEmpty()) {
                        step = 5;
                    }
                }
                if (step != 5) break block21;
                if (param3222 == null) {
                    Parser<WebSocketParam> param3222 = http.parseWebSocketParam(input);
                } else {
                    void param3222;
                    Parser param3222 = param3222.feed(input);
                }
                if (!param3222.isDone()) break;
                params.add((Object)((WebSocketParam)param3222.bind()));
                Object param3222 = null;
                step = 3;
            }
            if (param3222.isError()) {
                return param3222.asError();
            }
        }
        if (!input.isError()) void param3222;
        return new WebSocketExtensionParser(http, name, (Parser<WebSocketParam>)param3222, (Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>>)params, step);
        return WebSocketExtensionParser.error((Throwable)input.trap());
    }

    static Parser<WebSocketExtension> parse(Input input, HttpParser http) {
        return WebSocketExtensionParser.parse(input, http, null, null, null, 1);
    }

    public Parser<WebSocketExtension> feed(Input input) {
        return WebSocketExtensionParser.parse(input, this.http, this.name, this.param, this.params, this.step);
    }
}

