/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.MediaRange;
import swim.http.header.AcceptParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class Accept
extends HttpHeader {
    private static int hashSeed;
    final FingerTrieSeq<MediaRange> mediaRanges;

    Accept(FingerTrieSeq<MediaRange> mediaRanges) {
        this.mediaRanges = mediaRanges;
    }

    public static Accept from(FingerTrieSeq<MediaRange> mediaRanges) {
        return new Accept(mediaRanges);
    }

    public static Accept from(MediaRange ... mediaRanges) {
        return new Accept((FingerTrieSeq<MediaRange>)FingerTrieSeq.of((Object[])mediaRanges));
    }

    public static Accept from(String ... mediaRangeStrings) {
        Builder mediaRanges = FingerTrieSeq.builder();
        int n = mediaRangeStrings.length;
        for (int i = 0; i < n; ++i) {
            mediaRanges.add((Object)MediaRange.parse(mediaRangeStrings[i]));
        }
        return new Accept((FingerTrieSeq<MediaRange>)((FingerTrieSeq)mediaRanges.bind()));
    }

    public static Parser<Accept> parseHttpValue(Input input, HttpParser http) {
        return AcceptParser.parse(input, http);
    }

    @Override
    public String lowerCaseName() {
        return "accept";
    }

    @Override
    public String name() {
        return "Accept";
    }

    public FingerTrieSeq<MediaRange> mediaRanges() {
        return this.mediaRanges;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.mediaRanges.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Accept) {
            Accept that = (Accept)other;
            return this.mediaRanges.equals(that.mediaRanges);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Accept.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.mediaRanges.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Accept").write(46).write("from").write(40);
        int n = this.mediaRanges.size();
        if (n > 0) {
            output.debug(this.mediaRanges.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.mediaRanges.get(i));
            }
        }
        output = output.write(41);
    }
}

