/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.ContentCoding;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.AcceptEncodingParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptEncoding
extends HttpHeader {
    private static int hashSeed;
    final FingerTrieSeq<ContentCoding> codings;

    AcceptEncoding(FingerTrieSeq<ContentCoding> codings) {
        this.codings = codings;
    }

    public static AcceptEncoding from(FingerTrieSeq<ContentCoding> codings) {
        return new AcceptEncoding(codings);
    }

    public static AcceptEncoding from(ContentCoding ... codings) {
        return new AcceptEncoding((FingerTrieSeq<ContentCoding>)FingerTrieSeq.of((Object[])codings));
    }

    public static AcceptEncoding from(String ... codingStrings) {
        Builder codings = FingerTrieSeq.builder();
        int n = codingStrings.length;
        for (int i = 0; i < n; ++i) {
            codings.add((Object)ContentCoding.parse(codingStrings[i]));
        }
        return new AcceptEncoding((FingerTrieSeq<ContentCoding>)((FingerTrieSeq)codings.bind()));
    }

    public static Parser<AcceptEncoding> parseHttpValue(Input input, HttpParser http) {
        return AcceptEncodingParser.parse(input, http);
    }

    @Override
    public boolean isBlank() {
        return this.codings.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "accept-encoding";
    }

    @Override
    public String name() {
        return "Accept-Encoding";
    }

    public FingerTrieSeq<ContentCoding> codings() {
        return this.codings;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.codings.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptEncoding) {
            AcceptEncoding that = (AcceptEncoding)other;
            return this.codings.equals(that.codings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptEncoding.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.codings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("AcceptEncoding").write(46).write("from").write(40);
        int n = this.codings.size();
        if (n > 0) {
            output.debug(this.codings.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.codings.get(i));
            }
        }
        output = output.write(41);
    }
}

