/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.LanguageRange;
import swim.http.header.AcceptLanguageParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptLanguage
extends HttpHeader {
    private static int hashSeed;
    final FingerTrieSeq<LanguageRange> languages;

    AcceptLanguage(FingerTrieSeq<LanguageRange> languages) {
        this.languages = languages;
    }

    public static AcceptLanguage from(FingerTrieSeq<LanguageRange> languages) {
        return new AcceptLanguage(languages);
    }

    public static AcceptLanguage from(LanguageRange ... languages) {
        return new AcceptLanguage((FingerTrieSeq<LanguageRange>)FingerTrieSeq.of((Object[])languages));
    }

    public static AcceptLanguage from(String ... languageStrings) {
        Builder languages = FingerTrieSeq.builder();
        int n = languageStrings.length;
        for (int i = 0; i < n; ++i) {
            languages.add((Object)LanguageRange.parse(languageStrings[i]));
        }
        return new AcceptLanguage((FingerTrieSeq<LanguageRange>)((FingerTrieSeq)languages.bind()));
    }

    public static Parser<AcceptLanguage> parseHttpValue(Input input, HttpParser http) {
        return AcceptLanguageParser.parse(input, http);
    }

    @Override
    public boolean isBlank() {
        return this.languages.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "accept-language";
    }

    @Override
    public String name() {
        return "Accept-Language";
    }

    public FingerTrieSeq<LanguageRange> languages() {
        return this.languages;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.languages.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptLanguage) {
            AcceptLanguage that = (AcceptLanguage)other;
            return this.languages.equals(that.languages);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptLanguage.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.languages.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("AcceptLanguage").write(46).write("from").write(40);
        int n = this.languages.size();
        if (n > 0) {
            output.debug(this.languages.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.languages.get(i));
            }
        }
        output = output.write(41);
    }
}

