/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpMethod;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.AllowParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class Allow
extends HttpHeader {
    private static int hashSeed;
    final FingerTrieSeq<HttpMethod> methods;

    Allow(FingerTrieSeq<HttpMethod> methods) {
        this.methods = methods;
    }

    public static Allow from(FingerTrieSeq<HttpMethod> methods) {
        return new Allow(methods);
    }

    public static Allow from(HttpMethod ... methods) {
        return new Allow((FingerTrieSeq<HttpMethod>)FingerTrieSeq.of((Object[])methods));
    }

    public static Allow from(String ... methodStrings) {
        Builder methods = FingerTrieSeq.builder();
        int n = methodStrings.length;
        for (int i = 0; i < n; ++i) {
            methods.add((Object)HttpMethod.parseHttp(methodStrings[i]));
        }
        return new Allow((FingerTrieSeq<HttpMethod>)((FingerTrieSeq)methods.bind()));
    }

    public static Parser<Allow> parseHttpValue(Input input, HttpParser http) {
        return AllowParser.parse(input, http);
    }

    @Override
    public boolean isBlank() {
        return this.methods.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "allow";
    }

    @Override
    public String name() {
        return "Allow";
    }

    public FingerTrieSeq<HttpMethod> methods() {
        return this.methods;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.methods.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Allow) {
            Allow that = (Allow)other;
            return this.methods.equals(that.methods);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Allow.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.methods.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Allow").write(46).write("from").write(40);
        int n = this.methods.size();
        if (n > 0) {
            output.debug(this.methods.head());
            for (int i = 1; i < n; ++i) {
                output.debug((Object)", ").debug(this.methods.get(i));
            }
        }
        output = output.write(41);
    }
}

