/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.HttpParser;
import swim.http.header.Connection;

final class ConnectionParser
extends Parser<Connection> {
    final HttpParser http;
    final Parser<FingerTrieSeq<String>> options;

    ConnectionParser(HttpParser http, Parser<FingerTrieSeq<String>> options) {
        this.http = http;
        this.options = options;
    }

    ConnectionParser(HttpParser http) {
        this(http, null);
    }

    static Parser<Connection> parse(Input input, HttpParser http, Parser<FingerTrieSeq<String>> options) {
        if ((options = options == null ? http.parseTokenList(input) : options.feed(input)).isDone()) {
            FingerTrieSeq tokens = (FingerTrieSeq)options.bind();
            if (!tokens.isEmpty()) {
                return ConnectionParser.done((Object)Connection.from((FingerTrieSeq<String>)tokens));
            }
            return ConnectionParser.error((Diagnostic)Diagnostic.expected((String)"connection option", (Input)input));
        }
        if (options.isError()) {
            return options.asError();
        }
        if (input.isError()) {
            return ConnectionParser.error((Throwable)input.trap());
        }
        return new ConnectionParser(http, (Parser<FingerTrieSeq<String>>)options);
    }

    static Parser<Connection> parse(Input input, HttpParser http) {
        return ConnectionParser.parse(input, http, null);
    }

    public Parser<Connection> feed(Input input) {
        return ConnectionParser.parse(input, this.http, this.options);
    }
}

