/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ContentEncodingParser;
import swim.util.Murmur3;

public final class ContentEncoding
extends HttpHeader {
    private static int hashSeed;
    final FingerTrieSeq<String> codings;

    ContentEncoding(FingerTrieSeq<String> codings) {
        this.codings = codings;
    }

    public static ContentEncoding from(FingerTrieSeq<String> codings) {
        return new ContentEncoding(codings);
    }

    public static ContentEncoding from(String ... codings) {
        return new ContentEncoding((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])codings));
    }

    public static Parser<ContentEncoding> parseHttpValue(Input input, HttpParser http) {
        return ContentEncodingParser.parse(input, http);
    }

    @Override
    public boolean isBlank() {
        return this.codings.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "content-encoding";
    }

    @Override
    public String name() {
        return "Content-Encoding";
    }

    public FingerTrieSeq<String> codings() {
        return this.codings;
    }

    public boolean contains(String coding) {
        FingerTrieSeq<String> codings = this.codings;
        int n = codings.size();
        for (int i = 0; i < n; ++i) {
            if (!coding.equalsIgnoreCase((String)codings.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(this.codings.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentEncoding) {
            ContentEncoding that = (ContentEncoding)other;
            return this.codings.equals(that.codings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentEncoding.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.codings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("ContentEncoding").write(46).write("from").write(40);
        int n = this.codings.size();
        if (n > 0) {
            output.debug(this.codings.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.codings.get(i));
            }
        }
        output = output.write(41);
    }
}

