/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.HttpParser;
import swim.http.header.ContentEncoding;

final class ContentEncodingParser
extends Parser<ContentEncoding> {
    final HttpParser http;
    final Parser<FingerTrieSeq<String>> codings;

    ContentEncodingParser(HttpParser http, Parser<FingerTrieSeq<String>> codings) {
        this.http = http;
        this.codings = codings;
    }

    ContentEncodingParser(HttpParser http) {
        this(http, null);
    }

    static Parser<ContentEncoding> parse(Input input, HttpParser http, Parser<FingerTrieSeq<String>> codings) {
        if ((codings = codings == null ? http.parseTokenList(input) : codings.feed(input)).isDone()) {
            FingerTrieSeq tokens = (FingerTrieSeq)codings.bind();
            if (!tokens.isEmpty()) {
                return ContentEncodingParser.done((Object)ContentEncoding.from((FingerTrieSeq<String>)tokens));
            }
            return ContentEncodingParser.error((Diagnostic)Diagnostic.expected((String)"content coding", (Input)input));
        }
        if (codings.isError()) {
            return codings.asError();
        }
        if (input.isError()) {
            return ContentEncodingParser.error((Throwable)input.trap());
        }
        return new ContentEncodingParser(http, (Parser<FingerTrieSeq<String>>)codings);
    }

    static Parser<ContentEncoding> parse(Input input, HttpParser http) {
        return ContentEncodingParser.parse(input, http, null);
    }

    public Parser<ContentEncoding> feed(Input input) {
        return ContentEncodingParser.parse(input, this.http, this.codings);
    }
}

