/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ContentLengthParser;
import swim.util.Murmur3;

public final class ContentLength
extends HttpHeader {
    private static int hashSeed;
    final long length;

    ContentLength(long length) {
        this.length = length;
    }

    public static ContentLength from(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException(Long.toString(length));
        }
        return new ContentLength(length);
    }

    public static Parser<ContentLength> parseHttpValue(Input input, HttpParser http) {
        return ContentLengthParser.parse(input);
    }

    @Override
    public String lowerCaseName() {
        return "content-length";
    }

    @Override
    public String name() {
        return "Content-Length";
    }

    public long length() {
        return this.length;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return Base10.writeLong((long)this.length, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentLength) {
            ContentLength that = (ContentLength)other;
            return this.length == that.length;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentLength.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.length)));
    }

    public void debug(Output<?> output) {
        output = output.write("ContentLength").write(46).write("from").write(40).debug((Object)this.length).write(41);
    }
}

