/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.ContentLength;

final class ContentLengthParser
extends Parser<ContentLength> {
    final long length;
    final int step;

    ContentLengthParser(long length, int step) {
        this.length = length;
        this.step = step;
    }

    ContentLengthParser() {
        this(0L, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<ContentLength> parse(Input input, long length, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Base10.isDigit((int)c)) return ContentLengthParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                length = Base10.decodeDigit((int)c);
                step = 2;
            } else if (input.isDone()) {
                return ContentLengthParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
                input = input.step();
                if ((length = 10L * length + (long)Base10.decodeDigit((int)c)) >= 0L) continue;
                return ContentLengthParser.error((Diagnostic)Diagnostic.message((String)"content length overflow", (Input)input));
            }
            if (!input.isEmpty()) {
                return ContentLengthParser.done((Object)ContentLength.from(length));
            }
        }
        if (!input.isError()) return new ContentLengthParser(length, step);
        return ContentLengthParser.error((Throwable)input.trap());
    }

    static Parser<ContentLength> parse(Input input) {
        return ContentLengthParser.parse(input, 0L, 1);
    }

    public Parser<ContentLength> feed(Input input) {
        return ContentLengthParser.parse(input, this.length, this.step);
    }
}

