/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.http.HttpParser;
import swim.http.MediaType;
import swim.http.header.ContentType;

final class ContentTypeParser
extends Parser<ContentType> {
    final HttpParser http;
    final Parser<MediaType> mediaType;

    ContentTypeParser(HttpParser http, Parser<MediaType> mediaType) {
        this.http = http;
        this.mediaType = mediaType;
    }

    ContentTypeParser(HttpParser http) {
        this(http, null);
    }

    static Parser<ContentType> parse(Input input, HttpParser http, Parser<MediaType> mediaType) {
        if ((mediaType = mediaType == null ? http.parseMediaType(input) : mediaType.feed(input)).isDone()) {
            return ContentTypeParser.done((Object)ContentType.from((MediaType)mediaType.bind()));
        }
        if (mediaType.isError()) {
            return mediaType.asError();
        }
        if (input.isError()) {
            return ContentTypeParser.error((Throwable)input.trap());
        }
        return new ContentTypeParser(http, (Parser<MediaType>)mediaType);
    }

    static Parser<ContentType> parse(Input input, HttpParser http) {
        return ContentTypeParser.parse(input, http, null);
    }

    public Parser<ContentType> feed(Input input) {
        return ContentTypeParser.parse(input, this.http, this.mediaType);
    }
}

