/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.Host;
import swim.uri.Uri;
import swim.uri.UriHost;
import swim.uri.UriPort;

final class HostParser
extends Parser<Host> {
    final Parser<UriHost> host;
    final Parser<UriPort> port;
    final int step;

    HostParser(Parser<UriHost> host, Parser<UriPort> port, int step) {
        this.host = host;
        this.port = port;
        this.step = step;
    }

    HostParser() {
        this(null, null, 1);
    }

    static Parser<Host> parse(Input input, Parser<UriHost> host, Parser<UriPort> port, int step) {
        if (step == 1) {
            if ((host = host == null ? Uri.standardParser().parseHost(input) : host.feed(input)).isDone()) {
                step = 2;
            } else if (host.isError()) {
                return host.asError();
            }
        }
        if (step == 2) {
            if (input.isCont() && input.head() == 58) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return HostParser.done((Object)Host.from((UriHost)host.bind()));
            }
        }
        if (step == 3) {
            if ((port = port == null ? Uri.standardParser().parsePort(input) : port.feed(input)).isDone()) {
                return HostParser.done((Object)Host.from((UriHost)host.bind(), (UriPort)port.bind()));
            }
            if (port.isError()) {
                return port.asError();
            }
        }
        if (input.isError()) {
            return HostParser.error((Throwable)input.trap());
        }
        return new HostParser((Parser<UriHost>)host, (Parser<UriPort>)port, step);
    }

    static Parser<Host> parse(Input input) {
        return HostParser.parse(input, null, null, 1);
    }

    public Parser<Host> feed(Input input) {
        return HostParser.parse(input, this.host, this.port, this.step);
    }
}

