/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.uri.UriHost;
import swim.uri.UriPort;

final class HostWriter
extends Writer<Object, Object> {
    final UriHost host;
    final UriPort port;
    final Writer<?, ?> part;
    final int step;

    HostWriter(UriHost host, UriPort port, Writer<?, ?> part, int step) {
        this.host = host;
        this.port = port;
        this.part = part;
        this.step = step;
    }

    HostWriter(UriHost host, UriPort port) {
        this(host, port, null, 1);
    }

    static Writer<Object, Object> write(Output<?> output, UriHost host, UriPort port, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? Unicode.writeString((Object)host.toString(), output) : part.pull(output)).isDone()) {
                part = null;
                if (!port.isDefined()) {
                    return HostWriter.done();
                }
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(58);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? Base10.writeInt((int)port.number(), (Output)output) : part.pull(output)).isDone()) {
                return HostWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return HostWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return HostWriter.error((Throwable)output.trap());
        }
        return new HostWriter(host, port, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, UriHost host, UriPort port) {
        return HostWriter.write(output, host, port, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HostWriter.write(output, this.host, this.port, this.part, this.step);
    }
}

